% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kenplot.R
\name{kenplot}
\alias{kenplot}
\title{Plot robust median ATS line for censored data}
\usage{
kenplot(
  y1,
  ycen,
  x1,
  xcen,
  atsline = FALSE,
  xnam = NULL,
  ynam = NULL,
  Title = "Akritas - Theil - Sen line",
  ylim = NULL,
  xlim = NULL,
  pch = 19,
  cex = 0.7,
  xaxs = "r",
  yaxs = "r",
  ...
)
}
\arguments{
\item{y1}{The column of y (response variable) values plus detection limits}

\item{ycen}{The y-variable indicators, where 1 (or \code{TRUE}) indicates a detection limit in the \code{y.var} column, and \code{0} (or \code{FALSE}) indicates a detected value in \code{y.var}.}

\item{x1}{The column of x (explanatory variable) values plus detection limits}

\item{xcen}{The x-variable indicators, where 1 (or \code{TRUE}) indicates a detection limit in the \code{x.var} column, and \code{0} (or \code{FALSE}) indicates a detected value in \code{x.var}.}

\item{atsline}{Indicator of whether to draw the ATS line or not. Default is FALSE.}

\item{xnam}{Custom label for the x axis of plots.  Default is x variable column name.}

\item{ynam}{Custom label for the y axis of plots.  Default is y variable column name.}

\item{Title}{Custom title for plots.  Default is "Akritas - Theil - Sen line".}

\item{ylim}{argument consistent with \code{base} plotting to adjust y-axis limits; see \code{par} for more details}

\item{xlim}{argument consistent with \code{base} plotting to adjust x-axis limits; see \code{par} for more details}

\item{pch}{argument consistent with \code{base} plotting to adjust point type, see \code{par} for more details}

\item{cex}{argument consistent with \code{base} plotting to adjust point size; see \code{par} for more details}

\item{xaxs}{argument consistent with \code{base} plotting to adjust x-axis type; see \code{par} for more details}

\item{yaxs}{argument consistent with \code{base} plotting to adjust y-axis type; see \code{par} for more details}

\item{...}{argument to adjust other base plotting functions; see \code{par} for more details}
}
\value{
Scatterplot of data plus ATS line.  Censored values are drawn for both X and Y variables as dashed lines up to the detection limits.
}
\description{
Function used by other functions to plot the Akritas-Theil-Sen (ATS) line for censored data.  Only one x variable allowed. Both Y and X variables may be censored.
}
\examples{
\dontrun{
# Both y and x are censored
data(PbHeron)
with(PbHeron, kenplot(Blood, BloodCen, Kidney, KidneyCen))

# x is not censored
data(Brumbaugh)
with(Brumbaugh, kenplot(Hg, HgCen, PctWetland,rep(0, times=length(PctWetland))))
}
}
\references{
Helsel, D.R., 2011. Statistics for Censored Environmental Data using Minitab and R, 2nd ed. John Wiley & Sons, USA, N.J.
}
