/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.eval;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.apache.mahout.cf.taste.eval.IRStatistics;

public final class IRStatisticsImpl
implements IRStatistics,
Serializable {
    private final double precision;
    private final double recall;
    private final double fallOut;
    private final double ndcg;
    private final double reach;

    IRStatisticsImpl(double precision, double recall, double fallOut, double ndcg, double reach) {
        Preconditions.checkArgument(precision >= 0.0 && precision <= 1.0, "Illegal precision: " + precision);
        Preconditions.checkArgument(recall >= 0.0 && recall <= 1.0, "Illegal recall: " + recall);
        Preconditions.checkArgument(fallOut >= 0.0 && fallOut <= 1.0, "Illegal fallOut: " + fallOut);
        Preconditions.checkArgument(ndcg >= 0.0 && ndcg <= 1.0, "Illegal nDCG: " + ndcg);
        Preconditions.checkArgument(reach >= 0.0 && reach <= 1.0, "Illegal reach: " + reach);
        this.precision = precision;
        this.recall = recall;
        this.fallOut = fallOut;
        this.ndcg = ndcg;
        this.reach = reach;
    }

    @Override
    public double getPrecision() {
        return this.precision;
    }

    @Override
    public double getRecall() {
        return this.recall;
    }

    @Override
    public double getFallOut() {
        return this.fallOut;
    }

    @Override
    public double getF1Measure() {
        return this.getFNMeasure(1.0);
    }

    @Override
    public double getFNMeasure(double b) {
        double b2 = b * b;
        double sum = b2 * this.precision + this.recall;
        return sum == 0.0 ? Double.NaN : (1.0 + b2) * this.precision * this.recall / sum;
    }

    @Override
    public double getNormalizedDiscountedCumulativeGain() {
        return this.ndcg;
    }

    @Override
    public double getReach() {
        return this.reach;
    }

    public String toString() {
        return "IRStatisticsImpl[precision:" + this.precision + ",recall:" + this.recall + ",fallOut:" + this.fallOut + ",nDCG:" + this.ndcg + ",reach:" + this.reach + ']';
    }
}

