/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.Cache;
import org.apache.mahout.cf.taste.impl.common.RefreshHelper;
import org.apache.mahout.cf.taste.impl.common.Retriever;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.Recommender;
import org.apache.mahout.common.LongPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CachingRecommender
implements Recommender {
    private static final Logger log = LoggerFactory.getLogger(CachingRecommender.class);
    private final Recommender recommender;
    private final int[] maxHowMany;
    private final Retriever<Long, Recommendations> recommendationsRetriever;
    private final Cache<Long, Recommendations> recommendationCache;
    private final Cache<LongPair, Float> estimatedPrefCache;
    private final RefreshHelper refreshHelper;
    private IDRescorer currentRescorer;

    public CachingRecommender(Recommender recommender) throws TasteException {
        Preconditions.checkArgument(recommender != null, "recommender is null");
        this.recommender = recommender;
        this.maxHowMany = new int[]{1};
        int numUsers = recommender.getDataModel().getNumUsers();
        this.recommendationsRetriever = new RecommendationRetriever();
        this.recommendationCache = new Cache<Long, Recommendations>(this.recommendationsRetriever, numUsers);
        this.estimatedPrefCache = new Cache<LongPair, Float>(new EstimatedPrefRetriever(), numUsers);
        this.refreshHelper = new RefreshHelper(new Callable<Object>(){

            @Override
            public Object call() {
                CachingRecommender.this.clear();
                return null;
            }
        });
        this.refreshHelper.addDependency(recommender);
    }

    private void setCurrentRescorer(IDRescorer rescorer) {
        if (rescorer == null) {
            if (this.currentRescorer != null) {
                this.currentRescorer = null;
                this.clear();
            }
        } else if (!rescorer.equals(this.currentRescorer)) {
            this.currentRescorer = rescorer;
            this.clear();
        }
    }

    @Override
    public List<RecommendedItem> recommend(long userID, int howMany) throws TasteException {
        return this.recommend(userID, howMany, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RecommendedItem> recommend(long userID, int howMany, IDRescorer rescorer) throws TasteException {
        Preconditions.checkArgument(howMany >= 1, "howMany must be at least 1");
        int[] nArray = this.maxHowMany;
        synchronized (this.maxHowMany) {
            List<RecommendedItem> recommendedItems;
            if (howMany > this.maxHowMany[0]) {
                this.maxHowMany[0] = howMany;
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (userID == Long.MIN_VALUE) {
                return this.recommendationsRetriever.get(Long.MIN_VALUE).getItems();
            }
            this.setCurrentRescorer(rescorer);
            Recommendations recommendations = this.recommendationCache.get(userID);
            if (recommendations.getItems().size() < howMany && !recommendations.isNoMoreRecommendableItems()) {
                this.clear(userID);
                recommendations = this.recommendationCache.get(userID);
                if (recommendations.getItems().size() < howMany) {
                    recommendations.setNoMoreRecommendableItems(true);
                }
            }
            return (recommendedItems = recommendations.getItems()).size() > howMany ? recommendedItems.subList(0, howMany) : recommendedItems;
        }
    }

    @Override
    public float estimatePreference(long userID, long itemID) throws TasteException {
        return this.estimatedPrefCache.get(new LongPair(userID, itemID)).floatValue();
    }

    @Override
    public void setPreference(long userID, long itemID, float value) throws TasteException {
        this.recommender.setPreference(userID, itemID, value);
        this.clear(userID);
    }

    @Override
    public void removePreference(long userID, long itemID) throws TasteException {
        this.recommender.removePreference(userID, itemID);
        this.clear(userID);
    }

    @Override
    public DataModel getDataModel() {
        return this.recommender.getDataModel();
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.refreshHelper.refresh(alreadyRefreshed);
    }

    public void clear(final long userID) {
        log.debug("Clearing recommendations for user ID '{}'", (Object)userID);
        this.recommendationCache.remove(userID);
        this.estimatedPrefCache.removeKeysMatching(new Cache.MatchPredicate<LongPair>(){

            @Override
            public boolean matches(LongPair userItemPair) {
                return userItemPair.getFirst() == userID;
            }
        });
    }

    public void clear() {
        log.debug("Clearing all recommendations...");
        this.recommendationCache.clear();
        this.estimatedPrefCache.clear();
    }

    public String toString() {
        return "CachingRecommender[recommender:" + this.recommender + ']';
    }

    private static final class Recommendations {
        private final List<RecommendedItem> items;
        private boolean noMoreRecommendableItems;

        private Recommendations(List<RecommendedItem> items) {
            this.items = items;
        }

        List<RecommendedItem> getItems() {
            return this.items;
        }

        boolean isNoMoreRecommendableItems() {
            return this.noMoreRecommendableItems;
        }

        void setNoMoreRecommendableItems(boolean noMoreRecommendableItems) {
            this.noMoreRecommendableItems = noMoreRecommendableItems;
        }
    }

    private final class EstimatedPrefRetriever
    implements Retriever<LongPair, Float> {
        private EstimatedPrefRetriever() {
        }

        @Override
        public Float get(LongPair key) throws TasteException {
            long userID = key.getFirst();
            long itemID = key.getSecond();
            log.debug("Retrieving estimated preference for user ID '{}' and item ID '{}'", (Object)userID, (Object)itemID);
            return Float.valueOf(CachingRecommender.this.recommender.estimatePreference(userID, itemID));
        }
    }

    private final class RecommendationRetriever
    implements Retriever<Long, Recommendations> {
        private RecommendationRetriever() {
        }

        @Override
        public Recommendations get(Long key) throws TasteException {
            log.debug("Retrieving new recommendations for user ID '{}'", (Object)key);
            int howMany = CachingRecommender.this.maxHowMany[0];
            IDRescorer rescorer = CachingRecommender.this.currentRescorer;
            List<RecommendedItem> recommendations = rescorer == null ? CachingRecommender.this.recommender.recommend(key, howMany) : CachingRecommender.this.recommender.recommend(key, howMany, rescorer);
            return new Recommendations(Collections.unmodifiableList(recommendations));
        }
    }
}

