/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online.eval;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.PatternFilenameFilter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import net.myrrix.common.ByValueAscComparator;
import net.myrrix.common.LangUtils;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.common.io.IOUtils;
import net.myrrix.common.iterator.FileLineIterable;
import net.myrrix.online.RescorerProvider;
import net.myrrix.online.ServerRecommender;
import net.myrrix.online.eval.DataFileContents;
import net.myrrix.online.eval.EvaluationResult;
import net.myrrix.online.eval.Evaluator;
import org.apache.commons.math3.util.FastMath;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.recommender.GenericRecommendedItem;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEvaluator
implements Evaluator {
    private static final Logger log = LoggerFactory.getLogger(AbstractEvaluator.class);
    private static final char DELIMITER = ',';
    private static final Splitter COMMA_TAB_SPLIT = Splitter.on(CharMatcher.anyOf(",\t")).omitEmptyStrings();

    @Override
    public final EvaluationResult evaluate(MyrrixRecommender recommender, Multimap<Long, RecommendedItem> testData) throws TasteException {
        return this.evaluate(recommender, null, testData);
    }

    protected abstract boolean isSplitTestByPrefValue();

    public final EvaluationResult evaluate(File originalDataDir) throws TasteException, IOException, InterruptedException {
        return this.evaluate(originalDataDir, 0.9, 1.0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final EvaluationResult evaluate(File originalDataDir, double trainingPercentage, double evaluationPercentage, RescorerProvider provider) throws TasteException, IOException, InterruptedException {
        EvaluationResult evaluationResult;
        Preconditions.checkArgument(trainingPercentage > 0.0 && trainingPercentage < 1.0, "Training % must be in (0,1): %s", trainingPercentage);
        Preconditions.checkArgument(evaluationPercentage > 0.0 && evaluationPercentage <= 1.0, "Eval % must be in (0,1): %s", evaluationPercentage);
        Preconditions.checkArgument(originalDataDir.exists() && originalDataDir.isDirectory(), "%s is not a directory", originalDataDir);
        File trainingDataDir = Files.createTempDir();
        trainingDataDir.deleteOnExit();
        File trainingFile = new File(trainingDataDir, "training.csv.gz");
        trainingFile.deleteOnExit();
        File trainingModelFile = new File(originalDataDir, "model.bin.gz");
        if (trainingModelFile.exists() && trainingModelFile.isFile()) {
            Files.copy(trainingModelFile, new File(trainingDataDir, trainingModelFile.getName()));
        }
        ServerRecommender recommender = null;
        try {
            Multimap<Long, RecommendedItem> testData = this.split(originalDataDir, trainingFile, trainingPercentage, evaluationPercentage, provider);
            recommender = new ServerRecommender(trainingDataDir);
            recommender.await();
            evaluationResult = this.evaluate(recommender, testData);
        }
        catch (Throwable throwable) {
            Closeables.close(recommender, true);
            IOUtils.deleteRecursively(trainingDataDir);
            throw throwable;
        }
        Closeables.close(recommender, true);
        IOUtils.deleteRecursively(trainingDataDir);
        return evaluationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Multimap<Long, RecommendedItem> split(File dataDir, File trainingFile, double trainPercentage, double evaluationPercentage, RescorerProvider provider) throws IOException {
        DataFileContents dataFileContents = AbstractEvaluator.readDataFile(dataDir, evaluationPercentage, provider);
        Multimap<Long, RecommendedItem> data = dataFileContents.getData();
        log.info("Read data for {} users from input; splitting...", (Object)data.size());
        ArrayListMultimap<Long, RecommendedItem> testData = ArrayListMultimap.create();
        Writer trainingOut = IOUtils.buildGZIPWriter(trainingFile);
        try {
            Iterator<Map.Entry<Long, Collection<RecommendedItem>>> it = data.asMap().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Long, Collection<RecommendedItem>> entry = it.next();
                long userID = entry.getKey();
                ArrayList userPrefs = Lists.newArrayList((Iterable)entry.getValue());
                it.remove();
                if (this.isSplitTestByPrefValue()) {
                    Collections.sort(userPrefs, ByValueAscComparator.INSTANCE);
                }
                int numTraining = FastMath.max(1, (int)(trainPercentage * (double)userPrefs.size()));
                for (RecommendedItem rec : userPrefs.subList(0, numTraining)) {
                    trainingOut.write(Long.toString(userID));
                    trainingOut.write(44);
                    trainingOut.write(Long.toString(rec.getItemID()));
                    trainingOut.write(44);
                    trainingOut.write(Float.toString(rec.getValue()));
                    trainingOut.write(10);
                }
                for (RecommendedItem rec : userPrefs.subList(numTraining, userPrefs.size())) {
                    testData.put(userID, rec);
                }
            }
            for (Map.Entry<String, RecommendedItem> entry : dataFileContents.getItemTags().entries()) {
                trainingOut.write(entry.getKey());
                trainingOut.write(44);
                trainingOut.write(Long.toString(entry.getValue().getItemID()));
                trainingOut.write(44);
                trainingOut.write(Float.toString(entry.getValue().getValue()));
                trainingOut.write(10);
            }
            for (Map.Entry<String, RecommendedItem> entry : dataFileContents.getUserTags().entries()) {
                trainingOut.write(Long.toString(entry.getValue().getItemID()));
                trainingOut.write(44);
                trainingOut.write(entry.getKey());
                trainingOut.write(44);
                trainingOut.write(Float.toString(entry.getValue().getValue()));
                trainingOut.write(10);
            }
        }
        finally {
            trainingOut.close();
        }
        log.info("{} users in test data", (Object)testData.size());
        return testData;
    }

    private static DataFileContents readDataFile(File dataDir, double evaluationPercentage, RescorerProvider provider) throws IOException {
        int perMillion = (int)(1000000.0 * FastMath.sqrt(evaluationPercentage));
        ArrayListMultimap<Long, RecommendedItem> data = ArrayListMultimap.create();
        ArrayListMultimap<String, RecommendedItem> itemTags = ArrayListMultimap.create();
        ArrayListMultimap<String, RecommendedItem> userTags = ArrayListMultimap.create();
        for (File dataFile : dataDir.listFiles(new PatternFilenameFilter(".+\\.csv(\\.(zip|gz))?"))) {
            log.info("Reading {}", (Object)dataFile);
            int count = 0;
            for (CharSequence line : new FileLineIterable(dataFile)) {
                String itemIDString;
                Iterator<String> parts = COMMA_TAB_SPLIT.split(line).iterator();
                String userIDString = parts.next();
                if (userIDString.hashCode() % 1000000 <= perMillion && (itemIDString = parts.next()).hashCode() % 1000000 <= perMillion) {
                    Long userID = null;
                    boolean userIsTag = userIDString.startsWith("\"");
                    if (!userIsTag) {
                        userID = Long.valueOf(userIDString);
                    }
                    boolean itemIsTag = itemIDString.startsWith("\"");
                    Long itemID = null;
                    if (!itemIsTag) {
                        itemID = Long.valueOf(itemIDString);
                    }
                    Preconditions.checkArgument(!userIsTag || !itemIsTag, "Can't have a user tag and item tag in one line");
                    if (parts.hasNext()) {
                        String token = parts.next().trim();
                        if (!token.isEmpty()) {
                            float value = LangUtils.parseFloat(token);
                            if (userIsTag) {
                                itemTags.put(userIDString, new GenericRecommendedItem(itemID, value));
                            } else if (itemIsTag) {
                                userTags.put(itemIDString, new GenericRecommendedItem(userID, value));
                            } else {
                                IDRescorer rescorer;
                                if (provider != null && (rescorer = provider.getRecommendRescorer(new long[]{userID}, null, new String[0])) != null) {
                                    value = (float)rescorer.rescore(itemID, value);
                                }
                                data.put(userID, new GenericRecommendedItem(itemID, value));
                            }
                        }
                    } else if (userIsTag) {
                        itemTags.put(userIDString, new GenericRecommendedItem(itemID, 1.0f));
                    } else if (itemIsTag) {
                        userTags.put(itemIDString, new GenericRecommendedItem(userID, 1.0f));
                    } else {
                        IDRescorer rescorer;
                        float value = 1.0f;
                        if (provider != null && (rescorer = provider.getRecommendRescorer(new long[]{userID}, null, new String[0])) != null) {
                            value = (float)rescorer.rescore(itemID, value);
                        }
                        data.put(userID, new GenericRecommendedItem(itemID, value));
                    }
                }
                if (++count % 1000000 != 0) continue;
                log.info("Finished {} lines", (Object)count);
            }
        }
        return new DataFileContents(data, itemTags, userTags);
    }
}

