/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender.svd;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Map;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.NoSuchUserException;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;

public class Factorization {
    private final FastByIDMap<Integer> userIDMapping;
    private final FastByIDMap<Integer> itemIDMapping;
    private final double[][] userFeatures;
    private final double[][] itemFeatures;

    public Factorization(FastByIDMap<Integer> userIDMapping, FastByIDMap<Integer> itemIDMapping, double[][] userFeatures, double[][] itemFeatures) {
        this.userIDMapping = Preconditions.checkNotNull(userIDMapping);
        this.itemIDMapping = Preconditions.checkNotNull(itemIDMapping);
        this.userFeatures = userFeatures;
        this.itemFeatures = itemFeatures;
    }

    public double[] getUserFeatures(long userID) throws NoSuchUserException {
        Integer index = this.userIDMapping.get(userID);
        if (index == null) {
            throw new NoSuchUserException(userID);
        }
        return this.userFeatures[index];
    }

    public double[] getItemFeatures(long itemID) throws NoSuchItemException {
        Integer index = this.itemIDMapping.get(itemID);
        if (index == null) {
            throw new NoSuchItemException(itemID);
        }
        return this.itemFeatures[index];
    }

    public Iterable<Map.Entry<Long, Integer>> getUserIDMappings() {
        return this.userIDMapping.entrySet();
    }

    public Iterable<Map.Entry<Long, Integer>> getItemIDMappings() {
        return this.itemIDMapping.entrySet();
    }

    public int numFeatures() {
        return this.userFeatures[0].length;
    }

    public int numUsers() {
        return this.userIDMapping.size();
    }

    public int numItems() {
        return this.itemIDMapping.size();
    }

    public boolean equals(Object o) {
        if (o instanceof Factorization) {
            Factorization other = (Factorization)o;
            return this.userIDMapping.equals(other.userIDMapping) && this.itemIDMapping.equals(other.itemIDMapping) && Arrays.deepEquals((Object[])this.userFeatures, (Object[])other.userFeatures) && Arrays.deepEquals((Object[])this.itemFeatures, (Object[])other.itemFeatures);
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 31 * this.userIDMapping.hashCode() + this.itemIDMapping.hashCode();
        hashCode = 31 * hashCode + Arrays.deepHashCode((Object[])this.userFeatures);
        hashCode = 31 * hashCode + Arrays.deepHashCode((Object[])this.itemFeatures);
        return hashCode;
    }
}

