% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tocher.R
\name{Tocher}
\alias{Tocher}
\title{Agrupamento Tocher}
\usage{
Tocher(Dist,
Metodo="original",
nperm=999,
Plot=1,
xlab="Dissimilaridade",
ylab="Distancia fenetica",
bty="n")
}
\arguments{
\item{Dist}{Objeto contendo a matriz de dissimilaridade}

\item{Metodo}{Um character indicando o algoritimo de agrupamento.
Ha duas possibidades: "original" (default) ou "sequential".
 O ultimo foi proposto por Vasconcelos et al. (2007), tambem chamando de
  metodo   Tocher modificado.}

\item{nperm}{Numero de permutacoes para identificar a signficancia pelo
metodo de Mantel}

\item{Plot}{Numero indicando qual grafico devera ser plotado:
 \itemize{
     \item"1": Grafico com as distancias intra e intercluster
     \item"2": Grafico com as dispersao da distancia cofenetica em funcao
      dos valores de dissimilaridade.
}}

\item{xlab}{nome do eixo x do grafico. Deve ser utilizado quando o Plot=2.}

\item{ylab}{nome do eixo y do grafico. Deve ser utilizado quando o Plot=2.}

\item{bty}{deve receber un character indicando o tipo de borda desejado no
  grafico. Deve ser utilizado quando o Plot=2.


   \itemize{
     \item"o": Todas as bordas
     \item"n": Sem bordas
     \item"7": Acima e a direita
     \item"L": Abaixo + esquerda (Default)
     \item"C": Acima + Direita + Abaixo
     \item"U": Direita + Abaixo + Direita
     }}
}
\value{
A funcao retorna resultados do teste Tocher.
}
\description{
Esta funcao faz o agrupamento pelo metodo Tocher
}
\examples{
\donttest{
data("Dados.MED")
Dist=Distancia(Dados.MED,Metodo=6)
Tocher(Dist)
}
}
\references{
PlayList "Curso de Analise Multivariada":
https://www.youtube.com/playlist?list=PLvth1ZcREyK72M3lFl7kBaHiVh5W53mlR


Cruz, C.D.; Ferreira, F.M.; Pessoni, L.A. (2011) Biometria aplicada ao estudo
da diversidade genetica. Visconde do Rio Branco: Suprema.

Rao, R.C. (1952) Advanced statistical methods in biometric research.
New York: John Wiley & Sons.

Sharma, J.R. (2006) Statistical and biometrical techniques in plant breeding.
Delhi: New Age International.
Silva, A.R. & Dias, C.T.S. (2013) A cophenetic correlation coefficient for
Tocher's method. Pesquisa Agropecuaria Brasileira, 48:589-596.

Vasconcelos, E.S.; Cruz, C.D.; Bhering, L.L.; Resende Junior, M.F.R. (2007) Alternative
   methodology for the cluster analysis. Pesquisa Agropecuaria Brasileira, 42:1421-1428.
}
