% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TN.R
\name{TN_metrics}
\alias{TN_metrics}
\title{Calculate Node and Global Metrics for Trait Networks}
\usage{
TN_metrics(graph)
}
\arguments{
\item{graph}{An igraph object representing the trait network, typically generated by the \code{TN} function.}
}
\value{
A list containing two data frames:
\item{node}{A data frame with node-level metrics including degree, closeness, betweenness, and local clustering coefficient.}
\item{global}{A data frame with global metrics including edge density, diameter, average path length, average clustering coefficient, and modularity.}
}
\description{
This function computes various node and global metrics for a trait network graph.
}
\examples{
data(WH)
WH <- WH[,4:23]
Tn_result <- TN(traits_matrix = WH, rThres = 0.2, pThres = 0.05)
TN_metrics(Tn_result)

}
\references{
\enumerate{
\item He, N., Li, Y., Liu, C., et al. (2020). Plant trait networks: improved resolution of the dimensionality of adaptation. Trends in Ecology & Evolution, 35(10), 908-918. https://doi.org/10.1016/j.tree.2020.06.003
\item Li, Y., Liu, C., Sack, L., Xu, L., Li, M., Zhang, J., & He, N. (2022). Leaf trait network architecture shifts with species‐richness and climate across forests at continental scale. Ecology Letters, 25(6), 1442-1457. https://doi.org/10.1111/ele.14009
}
}
