% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Commutators.R
\name{indx_Commutator_Moment}
\alias{indx_Commutator_Moment}
\title{Linear combination of moments}
\usage{
indx_Commutator_Moment(x, el_rm, d)
}
\arguments{
\item{x}{a vector of length d^n where n is length of (el_rm)}

\item{el_rm}{type of a partition}

\item{d}{dimensionality of the underlying multivariate distribution}
}
\value{
A vector K x
}
\description{
For a d-variate distribution it provides the product Kx where K is the moment commutator as 
produced by \code{matr_Commutator_Moment} and x is a vector of appropriate dimension. 
It avoids the construction of large commutators matrices working much faster 
with respect to \code{matr_Commutator_Moment}.
}
\examples{
n=4;  r=2 ;  m=1 ;  d=2;
PTA<-Partition_Type_All(n)
el_r<-PTA$eL_r[[r]][m,]
## el_r is a given type (always a vector)
x<-1:d^n
indx_Commutator_Moment(x,el_r,d)
# Same as
MC<- matr_Commutator_Moment(el_r,d)
as.vector(MC\%*\%x)
}
\references{
Gy., Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021, Section 2.4.3, p.100, Sect. A.2.1, p. 353.,
Corollary 2.6., p.95
}
\seealso{
Other Matrices and commutators: 
\code{\link{indx_Commutator_Kmn}()},
\code{\link{indx_Commutator_Kperm}()},
\code{\link{indx_Commutator_Mixing}()},
\code{\link{indx_Elimination}()},
\code{\link{indx_Qplication}()},
\code{\link{indx_Symmetry}()},
\code{\link{indx_UnivMomCum}()},
\code{\link{matr_Commutator_Kmn}()},
\code{\link{matr_Commutator_Kperm}()},
\code{\link{matr_Commutator_Mixing}()},
\code{\link{matr_Commutator_Moment}()},
\code{\link{matr_Elimination}()},
\code{\link{matr_Qplication}()},
\code{\link{matr_Symmetry}()}
}
\concept{Matrices and commutators}
