% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hermite.r
\name{Hermite_CoeffMulti}
\alias{Hermite_CoeffMulti}
\title{Coefficients of multivariate T-Hermite polynomials for standardized variate}
\usage{
Hermite_CoeffMulti(N, d)
}
\arguments{
\item{N}{the maximum order of polynomials}

\item{d}{the dimension of  d-variate X}
}
\value{
The list of matrices of coefficients for the d-variate polynomials from 1 to N
}
\description{
Provides the matrix of coefficients of
\eqn{x^{\otimes N}}, \eqn{\kappa_2^{\otimes}  x^{\otimes (N-2)}}...
for the d-variate T-Hermite polynomials  up to order N.
}
\examples{
N <- 5; d <- 3
H_N_Xc <- Hermite_CoeffMulti(N,d) # coefficients
X <- c(1:3);
X3 <- kronecker(X,kronecker(X,X));
X5 <- kronecker(X3,kronecker(X,X))
Idv <- as.vector(diag(d)) # vector of variance matrix
# value of H5 at X is
vH5<-H_N_Xc[[1]] \%*\% X5 + H_N_Xc[[2]] \%*\%kronecker(Idv,X3) +
  H_N_Xc[[3]] \%*\%kronecker(kronecker(Idv,Idv),X)
}
\references{
Gy.Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021.  Section 4.6.2, p. 223, Remark 4.8,
}
\seealso{
Other Hermite: 
\code{\link{Hermite_Coeff}()},
\code{\link{Hermite_N_Cov_X1_X2}()},
\code{\link{Hermite_Nth}()},
\code{\link{Hermite_Poly_HN_Multi}()},
\code{\link{Hermite_Poly_HN}()},
\code{\link{Hermite_Poly_NH_Inv}()},
\code{\link{Hermite_Poly_NH_Multi_Inv}()}
}
\concept{Hermite}
