% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InputsForMLEdensity.R
\name{InputsForMLEdensity}
\alias{InputsForMLEdensity}
\title{Generates several  inputs that are necessary to build the likelihood function}
\usage{
InputsForMLEdensity(
  ModelType,
  Yields,
  PdynamicsFactors,
  FactorLabels,
  mat,
  Economies,
  DataFrequency,
  JLLinputs = NULL,
  GVARinputs = NULL,
  BRWinputs = NULL
)
}
\arguments{
\item{ModelType}{string-vector containing the label of the model to be estimated}

\item{Yields}{time series of yields (JxT or CJ x T)}

\item{PdynamicsFactors}{time series of the risk factors (K x T)}

\item{FactorLabels}{string-list based which contains the labels of all variables present in the model}

\item{mat}{vector of maturities (in years) used in the estimation}

\item{Economies}{string-vector containing the names of the economies of the system. \cr
If the ModelType selected is "JPS", "JPS jointP", "GVAR sepQ", then only one economy can be selected. \cr
 For the other models, more than one economy must be selected.}

\item{DataFrequency}{character-based-vector. Avaialable options are: "Daily All Days", "Daily Business Days", "Weekly", "Monthly", "Quarterly", "Annually"}

\item{JLLinputs}{list of necessary inputs for the estimation of JLL-based models (see "JLL" function)}

\item{GVARinputs}{list of necessary inputs for the estimation of GVAR-based models (see "GVAR" function)}

\item{BRWinputs}{list of necessary inputs for performing the bias-corrected estimation (see "Bias_Correc_VAR" function)}
}
\value{
List of necessary inputs  for constructing the model's log-likelihood function
}
\description{
Generates several  inputs that are necessary to build the likelihood function
}
\details{
To ensure that the risk factors matrix is correctly built for the model "JPS", the global factors should be allocated on the first G rows of this matrix.
}
\examples{
\donttest{
# Example 1:
data(CM_Factors)
data(CM_Yields)

ModelType <- "JPS"
Economies <- "Mexico"
Factors <- RiskFactors
N <- 3
GlobalVar <- c("GBC", "CPI_OECD") # Global Variables
DomVar <- c("Eco_Act", "Inflation") # Domestic Variables
FactorLabels <- LabFac(N, DomVar,GlobalVar, Economies, ModelType)

mat <- c(0.25, 0.5, 1, 3, 5, 10)
DataFrequency <- "Monthly"

i <- length(Economies)
ATSMInputs <- InputsForMLEdensity(ModelType, Yields, Factors, FactorLabels, mat,
                                 Economies, DataFrequency)
# Example 2:
data(CM_Factors)
data(CM_Yields)
data(CM_Factors_GVAR)

ModelType <- "GVAR jointQ"
Economies <- c("China", "Brazil", "Mexico", "Uruguay")
mat <- c(0.25, 0.5, 1, 3, 5, 10)
DataFrequency <- "Monthly"
Factors  <- RiskFactors
N <- 3
GlobalVar <- c("GBC", "CPI_OECD") # Global Variables
DomVar <- c("Eco_Act", "Inflation") # Domestic Variables
FactorLabels <- LabFac(N, DomVar,GlobalVar, Economies, ModelType)

GVARinputs <- list()
GVARinputs$Economies <- Economies
GVARinputs$GVARFactors <- FactorsGVAR
GVARinputs$VARXtype <- "unconstrained"
GVARinputs$Wgvar <- matrix( c(0, 0.83, 0.86, 0.38,
               0.65, 0, 0.13, 0.55,
               0.32, 0.12, 0, 0.07,
               0.03, 0.05, 0.01, 0), nrow = 4, ncol = 4)
ATSMInputs <- InputsForMLEdensity(ModelType, Yields, Factors, FactorLabels, mat, Economies,
                                 DataFrequency, JLLinputs= NULL , GVARinputs)

# Example 3:
if (requireNamespace('neldermead', quietly = TRUE)) {

data(CM_Factors)
data(CM_Yields)
ModelType <- "JLL jointSigma"
GlobalVar <- c("GBC", "CPI_OECD") # Global Variables
DomVar <- c("Eco_Act", "Inflation") # Domestic Variables
N <- 3
Economies <- c( "China", "Brazil", "Mexico", "Uruguay")
FactorLabels <- LabFac(N, DomVar, GlobalVar, Economies, ModelType)

Factors <- RiskFactors
mat <- c(0.25, 0.5, 1, 3, 5, 10)
DataFrequency <- "Monthly"
JLLinputs <- list()
JLLinputs$Economies <- Economies
JLLinputs$DomUnit <- "China"
JLLinputs$WishSigmas <- 1
JLLinputs$SigmaNonOrtho <- NULL
JLLinputs$JLLModelType <- ModelType

ATSMInputs <- InputsForMLEdensity(ModelType, Yields, Factors, FactorLabels, mat, Economies,
                                 DataFrequency, JLLinputs)
} else {
 message("skipping functionality due to missing Suggested dependency")
}


}
}
