% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twosamplesurvpvs.R
\name{twosamplesurvpvs}
\alias{twosamplesurvpvs}
\title{Two Sample Omnibus Tests of Survival Curves}
\usage{
twosamplesurvpvs(times, delta, grp, nmc = 10000, plotme = TRUE, exact = FALSE)
}
\arguments{
\item{times}{Event and censoring times}

\item{delta}{Indicator of event (1) or censoring (0).}

\item{grp}{Variable that divides the population into groups.}

\item{nmc}{Number of Monte Carlo samples for p value calculation}

\item{plotme}{logical; indicates whether to plot or not.}

\item{exact}{logical; indicates whether to use exhaustive enumeration of permutations or not.}
}
\value{
A vector of length two, with the Kolmogorov-Smirnov and Anderson-Darling statistics.
}
\description{
Returns the Kolmogorov-Smirnov and Anderson-Darling test statistics for two right-censored data sets.
}
\details{
The function calls a Fortran code to calculate the estimators \code{b} and their variance-covariance matrix \code{Vb}
}
\examples{
twosamplesurvpvs(rexp(20),rbinom(20,1,.5),rbinom(20,1,.5))
}
