% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testve.R
\name{testve}
\alias{testve}
\title{Diagnosis for multivariate stratified Kawaguchi - Koch - Wang method}
\usage{
testve(n, m, k, nsamp = 100, delta = 0, beta = 0, disc = 0)
}
\arguments{
\item{n}{number of observations in the first group.}

\item{m}{number of observations in the second group.}

\item{k}{number of strata.}

\item{nsamp}{The number of estimates that will be calculated. Must be enough to be sure that the results are interpretable.}

\item{delta}{Offset that depends on group.}

\item{beta}{Correlation between x and y.}

\item{disc}{The Mann Whitney test is designed to handle continuous data, but this method applies to discretized data; \code{disc} adjusts the discreteness.}
}
\value{
Nothing is returned.  A QQ plot is drawn.
}
\description{
Diagnostic tool that verifies the normality of the estimates of the probabilities b with the Kawaguchi - Koch - Wang method. The diagnostic method is based on a Monte Carlo method.
}
\details{
This functions serves as a diagnosis to prove that the Kawaguchi - Koch - Wang method gives Gaussian estimates for b. It generates random data sets, to which the Mann Whitney test gets applied.  \code{y} is the generated response variable and \code{x} the generated covariable related to \code{y} through a regression model.
}
\examples{
testve(10,15,3,100,0.4)
}
\references{
A. Kawaguchi, G. G. Koch and X. Wang (2012), "Stratified Multivariate Mann-Whitney Estimators for the Comparison of Two Treatments with Randomization Based Covariance Adjustment", \emph{Statistics in Biopharmaceutical Research} 3 (2) 217-231.

J. E. Kolassa and Y. Seifu (2013), Nonparametric Multivariate Inference on Shift Parameters, \emph{Academic Radiology} 20 (7), 883-888.
}
