\name{write.data}
\alias{write.data}
\title{
 Write multilocus genotype tables allowing to specify the use of manual or automatic binning methods
}
\description{
  Writes a multilocus genotype table from the data base allowing to specify for which loci should manual
  bin limits be used. In order to use manual defined bins you will need to use the function \code{\link{DefBinLim}} 
  previously
}
\usage{
write.data(DB,Mtable,file="MLG table")
}
\arguments{
  \item{DB}{ A data base of the type used by this package, like the generated by \code{\link{transDB}}}
  \item{Mtable}{ A data.frame with two columns Marker and Method, Marker contains the names of the markers in the Data base
  from where you want to write from; Method contains characters that can be "Alg" if you want to use the MsatAllele algorithm
  or the name of the data.frame returned by call to \code{\link{DefBinLim}} for the corresponding locus, if you want to use
  manually defined bin limits}
  \item{file}{the name of the file to output, don't use extensions. It defaults to "MLG table"}
}
\details{
  Start by producing the data.frame Mtable that specifies which method to use when writting the multilocus genotypes. 
  If you have previously defined manually bin limits you will need to provide the names of the objects that contain them
  in the second column of the Mtable argument (don't forget to use quotes). If you want to write all loci with the automatic
  method simply provide a second column filled with "Alg" for all loci.
}
\value{
  The function writes two files, with one and two columns per locus format.
}
\author{ Filipe Alberto }
\references{
Alberto F. MsatAllele_1.0: an R package to visualize the binning of microsatellite alleles Journal of Heredity. 100(3):394,397
}

\seealso{  \code{\link{write.PG.file.loc}}, \code{\link{write.PG.file.all}}}
\examples{data(DBase)
#In this example I am only using the automatic method
#To use manually defined bins replace the respective
# "Alg" by the name of the resulting obecjet from the
#DefBinLim function, don't forget to use quotes around
#the object name
MethodTab<-data.frame(Marker=unique(DBase$Marker),Method=c("Alg","Alg","Alg","Alg","Alg"))
write.data(DBase,Mtable=MethodTab)
}
\keyword{ manip }
