% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causalmpt.R
\name{causalmpt}
\alias{causalmpt}
\title{Causal Mplus Trees}
\usage{
causalmpt(
  script,
  data,
  rPartFormula,
  group = ~id,
  treat,
  outcome,
  est.samp = 0.2,
  ...
)
}
\arguments{
\item{script}{An \code{MplusAutomation} script file}

\item{data}{Dataset that is specified in the script}

\item{rPartFormula}{Formula of the form ~ variable names}

\item{group}{id variable. If not specified an id variable is created for each row}

\item{treat}{Treatment variable}

\item{outcome}{Univariate outcome of interest (dependent variable in mean comparison tests)}

\item{est.samp}{Proportion of sample to be used as holdout sample (estimation subsample)}

\item{...}{Other arguments to \code{MplusTrees} for building Mplus Tree}
}
\value{
An object of class '\code{causalmpt}'. Tree structure drawn from \code{MplusTrees()}. CATEs
estimated in estimation (holdout) subsample. Provides results of t tests to estimate CATEs in each
group and ANOVA to examine group differences in treatment effect.
}
\description{
Uses M\emph{plus} Trees to match on structural equation model parameters in matching subsample.
Then estimates Conditional Average Treatment Effects (CATEs) in holdout estimation subsample.
}
\details{
See documentation for \code{MplusTrees()} for further information on tree building process.
Takes terminal nodes from Mplus Tree and considers them "matched". Splits estimation subsample into
groups defined by covariate pattern in terminal nodes from Mplus Tree. Performs t tests in each group
with \code{treat} as independent variable and \code{outcome} as dependent variable to estimate CATEs.
Also performs ANOVA to determine if treatment effect differs by group (interaction).
}
\examples{
\dontrun{
library(lavaan)

script = mplusObject(
   TITLE = "Causal Mplus Trees Example",
   MODEL = "f1 BY x1-x3;",
   usevariables = c('x1','x2','x3'),
   rdata = HolzingerSwineford1939)

fit.cmpt = causalmpt(script, HolzingerSwineford1939, group=~id,
   rPartFormula=~school+grade,
   control=rpart.control(minsplit=100, minbucket=100, cp=.01),
   treat="sex", outcome="x4")
fit.cmpt
}
}
\references{
Serang, S., & Sears, J. (2021). Tree-based matching on structural equation model
parameters. Behavioral Data Science, 1, 31-53.
}
\author{
Sarfaraz Serang
}
