% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ages.R, R/mortalityTable.jointLives.R
\docType{methods}
\name{ages}
\alias{ages}
\alias{ages,mortalityTable.period-method}
\alias{ages,mortalityTable.mixed-method}
\alias{ages,mortalityTable.jointLives-method}
\title{Return the defined ages of the life table}
\usage{
ages(object, ...)

\S4method{ages}{mortalityTable.period}(object, ...)

\S4method{ages}{mortalityTable.mixed}(object, ...)

\S4method{ages}{mortalityTable.jointLives}(object, ...)
}
\arguments{
\item{object}{A life table object (instance of a \code{\linkS4class{mortalityTable}} class)}

\item{...}{Currently unused}
}
\description{
Return the defined ages of the life table
}
\section{Methods (by class)}{
\itemize{
\item \code{mortalityTable.period}: Return the defined ages of the period life table

\item \code{mortalityTable.mixed}: Return the defined ages of the mixed life table

\item \code{mortalityTable.jointLives}: Return the defined ages of the joint lives mortality table (returns the ages of the first table used for joint lives)
}}

\examples{
mortalityTables.load("Austria_*")
ages(AVOe2005R.male)
ages(AVOe1996R.male)
ages(mort.AT.census.2011.male)

}
