% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LC.R
\name{leecarter.estimate}
\alias{leecarter.estimate}
\title{Lee-Carter Estimation}
\usage{
leecarter.estimate(
  mx,
  ax.index = NULL,
  ax.smooth = FALSE,
  ax.smooth.df = NULL,
  bx.postprocess = TRUE,
  nx = 5
)
}
\arguments{
\item{mx}{A matrix of age-specific mortality rates where rows correspond to age groups
and columns correspond to time periods. Rownames define the starting ages of the age groups.}

\item{ax.index}{A vector of column indices of \code{mx} to be used to estimate the \eqn{a_x} parameter.
By default all time periods are used.}

\item{ax.smooth}{Logical allowing to smooth the \eqn{a_x} over ages.}

\item{ax.smooth.df}{Degree of freedom for smoothing if \code{ax.smooth} is \code{TRUE}. 
Default is half the length of \eqn{a_x}.}

\item{bx.postprocess}{Logical determining if numerical anomalies in \eqn{b_x} should be dealt with.}

\item{nx}{Size of age groups. By default ages are determined by rownames of \code{mx}. This argument is only used if 
\code{mx} has no rownames. If \code{nx} is 5, the age groups are interpreted as 0, 1, 5, 10, \dots. For \code{nx} equals 1, 
the age groups are interpreted as 0, 1, 2, 3, \dots.}
}
\value{
List with elements \code{ax}, \code{bx} and \code{kt} corresponding to the estimated parameters.
}
\description{
Estimate Lee-Carter parameters (Lee and Carter 1992).
}
\details{
The function estimates parameters of \eqn{\log(m_x(t)) = a_x + b_x k(t) + \epsilon_x(t)} (Lee and Carter 1992). 
The argument \code{ax.index} determines which time periods to use to 
estimate the \eqn{a_x} parameter, while \code{ax.smooth} controls if 
the resulting \eqn{a_x} should be smoothened over ages (see Sevcikova et al. 2016 for details).
}
\examples{
data(mxM, package = "wpp2017")
mx <- subset(mxM, name == "Netherlands")[,4:16]
rownames(mx) <- c(0,1, seq(5, 100, by=5))
lc.ax.avg <- leecarter.estimate(mx)
lc.ax.last <- leecarter.estimate(mx, ax.index=ncol(mx))
plot(lc.ax.avg$ax, type="l")
lines(lc.ax.last$ax, col="blue")

}
\references{
Lee, R. D. and Carter, L. (1992). Modeling and forecasting the time series of 
US mortality. Journal of the American Statistical Association, 87, 659-671.

Sevcikova H., Li N., Kantorova V., Gerland P., Raftery A.E. (2016). 
Age-Specific Mortality and Fertility Rates for Probabilistic Population Projections. 
In: Schoen R. (eds) Dynamic Demographic Analysis. The Springer Series on Demographic Methods
and Population Analysis, vol 39. Springer, Cham
}
\seealso{
\code{\link{mortcast}}, \code{\link{lileecarter.estimate}}
}
