% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file2mesh.r, R/obj2mesh.r, R/ply2mesh.r
\name{file2mesh}
\alias{file2mesh}
\alias{obj2mesh}
\alias{ply2mesh}
\title{Import 3D surface mesh files}
\usage{
file2mesh(filename, clean = TRUE, readcol = FALSE)

obj2mesh(filename, adnormals = TRUE)

ply2mesh(filename, adnormals = TRUE, readnormals = FALSE,
  readcol = FALSE, silent = FALSE)
}
\arguments{
\item{filename}{character: path to file}

\item{clean}{Logical: Delete dumpfiles.}

\item{readcol}{Logical: Import vertex colors (if available).}

\item{adnormals}{Logical: If the file does not contain normal information,
they will be calculated in R: Can take some time.}

\item{readnormals}{Logical: Import vertex normals (if available), although
no face information is present.}

\item{silent}{logical: suppress messages.}
}
\value{
\item{mesh }{list of class mesh3d - see rgl manual for further details,
or a matrix containing vertex information or a list containing vertex and
normal information}
}
\description{
Import 3D surface mesh files
}
\details{
imports 3D mesh files and store them as an R .object of class mesh3d
}
\examples{

data(nose)
mesh2ply(shortnose.mesh)
mesh <- ply2mesh("shortnose.mesh.ply")

mesh2obj(shortnose.mesh)
mesh2 <- obj2mesh("shortnose.mesh.obj")
## cleanup
unlink(c("shortnose.mesh.obj","shortnose.mesh.ply"))
}
