% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-out-sfourier.R
\name{sfourier_i}
\alias{sfourier_i}
\title{Inverse radii variation Fourier transform}
\usage{
sfourier_i(rf, nb.h, nb.pts = 120, dtheta = FALSE)
}
\arguments{
\item{rf}{A \code{list} with \code{ao}, \code{an} and \code{bn} components,
typically as returned by \code{sfourier}.}

\item{nb.h}{\code{integer}. The number of harmonics to calculate/use.}

\item{nb.pts}{\code{integer}. The number of points to calculate.}

\item{dtheta}{\code{logical}. Whether to use the dtheta correction method.
\code{FALSE} by default. When \code{TRUE}, tries to correct the angular difference between
reconstructed points; otherwise equal angles are used.}
}
\value{
A list with components: \item{x }{\code{vector} of
\code{x}-coordinates.} \item{y }{\code{vector} of \code{y}-coordinates.}
\item{angle}{\code{vector} of angles used.} \item{r}{\code{vector} of radii
calculated.}
}
\description{
\code{sfourier_i} uses the inverse radii variation (equally spaced curvilinear abscissa) transformation to
calculate a shape, when given a list with Fourier coefficients, typically
obtained computed with \link{sfourier}.
}
\examples{
coo <- coo_center(bot[1]) # centering is almost mandatory for sfourier family
coo_plot(coo)
rf  <- sfourier(coo, 12)
rf
rfi <- sfourier_i(rf)
coo_draw(rfi, border='red', col=NA)

}
\references{
Renaud S, Pale JRM, Michaux JR (2003): Adaptive latitudinal trends in the mandible shape
of \emph{Apodemus} wood mice. \emph{J Biogeogr} 30:1617-1628.
}
\seealso{
Other sfourier: 
\code{\link{sfourier_shape}()},
\code{\link{sfourier}()}
}
\concept{sfourier}
