% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr-PCA.R
\name{scree}
\alias{scree}
\alias{scree.PCA}
\alias{scree.LDA}
\alias{scree_min}
\alias{scree_plot}
\title{How many axes to retain this much of variance or trace ?}
\usage{
scree(x, nax)

\method{scree}{PCA}(x, nax)

\method{scree}{LDA}(x, nax)

scree_min(x, prop)

scree_plot(x, nax)
}
\arguments{
\item{x}{a \link{PCA} object}

\item{nax}{numeric range of axes to consider.
All by default for \code{scree_min}, display until \code{0.99} for \code{scree_plot}}

\item{prop}{numeric how many axes are enough to gather this proportion of variance.
Default to 1, all axes are returned
defaut to 1: all axis are returned}
}
\value{
scree returns a data.frame, scree_min a numeric, scree_plot a ggplot.
}
\description{
A set of functions around PCA/LDA eigen/trace. \code{scree} calculates their proportion and cumulated proportion;
\code{scree_min} returns the minimal number of axis to use to retain a given proportion; \code{scree_plot} displays a screeplot.
}
\examples{
# On PCA
bp <- PCA(efourier(bot))
scree(bp)
scree_min(bp, 0.99)
scree_min(bp, 1)

scree_plot(bp)
scree_plot(bp, 1:5)

# on LDA, it uses svd
bl <- LDA(PCA(opoly(olea)), "var")
scree(bl)

}
