% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-calibrate.R
\name{calibrate_harmonicpower}
\alias{calibrate_harmonicpower}
\alias{calibrate_harmonicpower_efourier}
\alias{calibrate_harmonicpower_rfourier}
\alias{calibrate_harmonicpower_tfourier}
\alias{calibrate_harmonicpower_sfourier}
\alias{calibrate_harmonicpower_dfourier}
\title{Quantitative calibration, through harmonic power, for Out and Opn objects}
\usage{
calibrate_harmonicpower()

calibrate_harmonicpower_efourier(
  x,
  id = 1:length(x),
  nb.h,
  drop = 1,
  thresh = c(90, 95, 99, 99.9),
  plot = TRUE
)

calibrate_harmonicpower_rfourier(
  x,
  id = 1:length(x),
  nb.h,
  drop = 1,
  thresh = c(90, 95, 99, 99.9),
  plot = TRUE
)

calibrate_harmonicpower_tfourier(
  x,
  id = 1:length(x),
  nb.h,
  drop = 1,
  thresh = c(90, 95, 99, 99.9),
  plot = TRUE
)

calibrate_harmonicpower_sfourier(
  x,
  id = 1:length(x),
  nb.h,
  drop = 1,
  thresh = c(90, 95, 99, 99.9),
  plot = TRUE
)

calibrate_harmonicpower_dfourier(
  x,
  id = 1:length(x),
  nb.h,
  drop = 1,
  thresh = c(90, 95, 99, 99.9),
  plot = TRUE
)
}
\arguments{
\item{x}{a \code{Coo} of \code{Opn} object}

\item{id}{the shapes on which to perform calibrate_harmonicpower. All of them by default}

\item{nb.h}{numeric the maximum number of harmonic, on which to base the cumsum}

\item{drop}{numeric the number of harmonics to drop for the cumulative sum}

\item{thresh}{vector of numeric for drawing horizontal lines, and also used for
\code{minh} below}

\item{plot}{logical whether to plot the result or simply return the matrix
Silent message and progress bars (if any) with \code{options("verbose"=FALSE)}.}
}
\value{
returns a list with component:
\itemize{
\item \code{gg} a ggplot object, \code{q} the quantile matrix
\item \code{minh} a quick summary that returns the number of harmonics required to achieve
a certain proportion of the total harmonic power.
}
}
\description{
Estimates the number of harmonics required for the four Fourier methods
implemented in Momocs: elliptical Fourier analysis
(see \link{efourier}), radii variation analysis (see \link{rfourier})
and tangent angle analysis (see \link{tfourier}) and
discrete Fourier transform (see \link{dfourier}).
It returns and can plot cumulated harmonic power whether dropping
the first harmonic or not, and based and the maximum possible number
of harmonics on the \code{Coo} object.
}
\details{
The power of a given harmonic \eqn{n} is calculated as follows for
elliptical Fourier analysis and the n-th harmonic:
\eqn{HarmonicPower_n \frac{A^2_n+B^2_n+C^2_n+D^2_n}{2}}
and as follows for radii variation and tangent angle:
\eqn{HarmonicPower_n= \frac{A^2_n+B^2_n+C^2_n+D^2_n}{2}}
}
\examples{
b5 <- bot \%>\% slice(1:5)
b5  \%>\% calibrate_harmonicpower_efourier(nb.h=12)
b5  \%>\% calibrate_harmonicpower_rfourier(nb.h=12)
b5  \%>\% calibrate_harmonicpower_tfourier(nb.h=12)
b5  \%>\% calibrate_harmonicpower_sfourier(nb.h=12)

# on Opn
olea \%>\% slice(1:5) \%>\%
    calibrate_harmonicpower_dfourier(nb.h=12)
\dontrun{
# let customize the ggplot
library(ggplot2)
cal <- b5  \%>\% calibrate_harmonicpower_efourier(nb.h=12)
cal$gg + theme_minimal() +
coord_cartesian(xlim=c(3.5, 12.5), ylim=c(90, 100)) +
ggtitle("Harmonic power calibration")
}
}
\seealso{
Other calibration: 
\code{\link{calibrate_deviations}()},
\code{\link{calibrate_r2}()},
\code{\link{calibrate_reconstructions}}
}
\concept{calibration}
