% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr-PCA2.R
\name{plot2}
\alias{plot2}
\alias{plot2.PCA}
\title{Plots Principal Component Analysis ala ggplot2}
\usage{
plot2(x, ...)

\method{plot2}{PCA}(x, fac = NULL, xax = "PC1", yax = "PC2",
  points = TRUE, shapes = TRUE, shapes_pos = "full", ellipse = FALSE,
  ellipseax = FALSE, ellipse_type = "t", ellipse_level = 0.5,
  stars = FALSE, chull = FALSE, text, text_abbreviatemin = 1,
  text_size = 5, center = TRUE, legend_position = "bottom",
  title = substitute(x), return_df = FALSE, ...)
}
\arguments{
\item{x}{a PCA object}

\item{...}{more arguments to be passed to xxx.}

\item{fac}{(optionnal)}

\item{xax}{the name of the component to plot on the x-axis, eg "PC1"}

\item{yax}{the name of the component to plot on the y-axis, eg "PC2"}

\item{points}{logical whether to draw points}

\item{shapes}{logical whether to draw shapes}

\item{shapes_pos}{a position parameter xxx either "axes", "full", "range", "circle", "xy"
or a custom data.frame of positions}

\item{ellipse}{logical whether to draw confidence ellipses}

\item{ellipseax}{logical whether to draw confidence ellipses axes}

\item{ellipse_type}{character one of the available type in ggplot2::stat_ellipse}

\item{ellipse_level}{numeric the confidence level for ellipses}

\item{stars}{logical whether to draw segments between every point and their group centroid}

\item{chull}{logical whether to draw convex hull}

\item{text}{numeric : 1 is for labelling every shape,
2 for group centroids, 3 is for evry shape using group names}

\item{text_abbreviatemin}{numeric if not missing, the min.length sensu \link{abbreviate}}

\item{text_size}{numeric to adjust the size of labels}

\item{center}{logical whether to center the plot}

\item{legend_position}{character for theme(legend.position),
either "none", "top", "bottom", "left", "right"}

\item{title}{character a title for the plot}

\item{return_df}{logical whether to return ggplot or the data_frames behind}
}
\value{
a ggplot object or a list of data.frames :
\itemize{
\item df0
\item df_shp
\item df_ellipseax
\item df_stars
\item df_chull
}
}
\description{
Displays a \link{PCA} object with many useful layers in morphometrics,
notably morphological space.
}
\details{
Detail the df_s. Detail the calculations.
}
\examples{
#data(bot)
#bp <- PCA(efourier(bot, 8))
#plot2(bp)
#plot2(bp, "type")
#plot2(bp, "type", ellipse=TRUE)
# data(bot)

# bot$fac$fake <- factor(rep(letters[1:4], 10))
# bot$fac$fake2 <- c(runif(20), runif(20, 5, 10))
# xx + stat_density2d(aes(fill = ..level..), geom="polygon", alpha=0.1)
}
