% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-opn-dct.R
\name{dfourier_i}
\alias{dfourier_i}
\title{Investe discrete cosinus transform}
\usage{
dfourier_i(df, nb.h, nb.pts = 60)
}
\arguments{
\item{df}{a list with \code{$A} and \code{$B} components, containing harmonic coefficients.}

\item{nb.h}{a custom number of harmonics to use}

\item{nb.pts}{numeric the number of pts for the shape reconstruction}
}
\value{
a matrix of (x; y) coordinates
}
\description{
Calculates inverse discrete cosine transforms (see \link{dfourier}), given a list of A and B harmonic coefficients,
typically such as those produced by \link{dfourier}.
}
\note{
Only the core functions so far. Will be implemented as an \link{Opn} method soon.
}
\examples{
# dfourier and inverse dfourier
data(olea)
o <- olea[1]
o <- coo_bookstein(o)
coo_plot(o)
o.dfourier <- dfourier(o, nb.h=12)
o.dfourier
o.i <- dfourier_i(o.dfourier)
o.i <- coo_bookstein(o.i)
coo_draw(o.i, border='red')

o <- olea[1]
h.range <- 2:13
coo <- list()
for (i in seq(along=h.range)){
coo[[i]] <- dfourier_i(dfourier(o, nb.h=h.range[i]))}
names(coo) <- paste0('h', h.range)
panel(Opn(coo), borders=col_india(12), names=TRUE)
title('Discrete Cosine Transforms')
}
\references{
\itemize{
 \item Dommergues, C. H., Dommergues, J.-L., & Verrecchia, E. P. (2007).
 The Discrete Cosine Transform, a Fourier-related Method for Morphometric Analysis of Open Contours.
 \emph{Mathematical Geology}, 39(8), 749-763. doi:10.1007/s11004-007-9124-6
 \item Many thanks to Remi Laffont for the translation in R).
}
}
\seealso{
Other dfourier: \code{\link{dfourier_shape}},
  \code{\link{dfourier}}
}
