% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/babel-bridges.R
\name{m2a}
\alias{m2a}
\title{Converts a matrix of coordinates to an array of coordinates}
\usage{
m2a(m)
}
\arguments{
\item{m}{a matrix (see above).}
}
\value{
an array (see above).
}
\description{
Converts a matrix arranged with the individuals (the 3rd dimension of the array) as rows,
and (all) x coordinates and (all) y coordinates as columns, into an array built as follows:
nb.of.landmarks x 2 (x; y) x nb.of.individuals.
}
\details{
Used in landmarks methods.
}
\examples{
data(wings)
m <- a2m(l2a(wings$coo))
m2a(m)
}
\seealso{
\link{a2m} the reverse function.

Other bridges functions: \code{\link{a2l}},
  \code{\link{a2m}}, \code{\link{as_df}},
  \code{\link{l2a}}, \code{\link{l2m}}, \code{\link{m2d}},
  \code{\link{m2ll}}, \code{\link{m2l}}
}

