% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-out-efourier.R
\name{efourier_norm}
\alias{efourier_norm}
\title{Normalizes harmonic coefficients.}
\usage{
efourier_norm(ef, start = FALSE)
}
\arguments{
\item{ef}{\code{list}. A list containing \eqn{a_n}, \eqn{b_n}, \eqn{c_n} and
\eqn{d_n} Fourier coefficients, such as returned by \code{efourier}.}

\item{start}{\code{logical}. Whether to conserve the position of the first
point of the outline.}
}
\value{
A list with the following components:
\itemize{
 \item \code{A} vector of \eqn{A_{1->n}} \emph{normalized} harmonic coefficients
 \item \code{B} vector of \eqn{B_{1->n}} \emph{normalized} harmonic coefficients
 \item \code{C} vector of \eqn{C_{1->n}} \emph{normalized} harmonic coefficients
 \item \code{D} vector of \eqn{D_{1->n}} \emph{normalized} harmonic coefficients
 \item \code{size} Magnitude of the semi-major axis of the first
fitting ellipse
\item \code{theta} angle, in radians, between the starting
point and the semi-major axis of the first fitting ellipse
\item psi orientation of the first fitting ellipse
\item \code{ao} ao harmonic coefficient
\item \code{co} co Harmonic coefficient
\item \code{lnef} a list with A, B, C and D concatenated in a vector.
}
}
\description{
\code{efourier_norm} normalizes Fourier coefficients for rotation,
tranlation, size and orientation of the first ellipse.
}
\details{
See \link{efourier} for the mathematical background of the normalization.

Sometimes shapes do not 'align' well each others, and this is usually detectable
on a morphospace on a regular PCA. You mat find 180 degrees rotated shapes or bizarre clustering.
Most of the time this is due to a poor normalization on the matrix of coefficients, and the
variability you observe may mostly be due to the variability in the alignment of the
'first' ellipsis which is defined by the first harmonic, used for the normalization. In that
case, you should align shapes \emph{before} \link{efourier} and with \code{norm = FALSE}. You
have several options: \link{coo_align}, \link{coo_aligncalliper}, \link{fgProcrustes} either directly on
the coordinates or on some landmarks along the outline or elsewhere on your original shape, depending of
what shall provide a good alignment. Have a look to Momocs' vignette for some illustration of these pitfalls
and how to manage them.
}
\examples{
data(bot)
q <- efourier(bot[1], 24)
efourier_i(q) # equivalent to efourier_shape(q$an, q$bn, q$cn, q$dn)
efourier_norm(q)
efourier_shape(nb.h=5, alpha=1.2)
efourier_shape(nb.h=12, alpha=0.9)
}
\references{
Claude, J. (2008) \emph{Morphometrics with R}, Use R! series,
Springer 316 pp.

Ferson S, Rohlf FJ, Koehn RK. 1985. Measuring shape variation of
two-dimensional outlines. \emph{Systematic Biology} \bold{34}: 59-68.
}
\seealso{
Other efourier: \code{\link{efourier_i}},
  \code{\link{efourier_shape}}, \code{\link{efourier}}
}

