% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mult-LDA.R
\name{classify}
\alias{classify}
\title{Classify using LDA}
\usage{
classify(x, fac, ref, unk)
}
\arguments{
\item{x}{a Coe}

\item{fac}{a standalone factor, or the name or id of the $fac column to use.If it contains
NAs, they will also be removed first from the x object}

\item{ref}{at least two level names from $fac[, "fac"] to use as a training subset of x}

\item{unk}{same as above for one level name to classify}
}
\value{
a list with components:
\itemize{
\item \code{$N_ref} the number of elements in the training set
\item \code{$N_unk} the number of elements in the unknown set
\item \code{$counts} counts of classification of 'unk' in each class of 'ref'
\item \code{$pc} same thing as percentages
\item \code{$probs} same thing as posterior probabilities
\item \code{$probs} same thing as posterior but as a data.frame
}
}
\description{
Classify using LDA
}
\examples{
data(olea)
table(olea, "var")
x <- opoly(olea, 5, verbose=FALSE)
classify(x, fac="var", ref=c("Aglan","Cypre"), unk="PicMa")
}

