% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-outopn-calibrate.R
\name{calibrate_harmonicpower}
\alias{calibrate_harmonicpower}
\title{Quantitative calibration, through harmonic power, for Out and Opn objects}
\usage{
calibrate_harmonicpower(x, method, id, nb.h, drop, thresh, plot, verbose)
}
\arguments{
\item{x}{a \code{Coo} of \code{Opn} object}

\item{method}{any method from \code{c('efourier', 'rfourier', 'tfourier')} for \code{Out}s and
\code{dfourier} for \code{Out}s.}

\item{id}{the shapes on which to perform calibrate_harmonicpower. All of them by default}

\item{nb.h}{numeric the maximum number of harmonic, on which to base the cumsum}

\item{drop}{numeric the number of harmonics to drop for the cumulative sum}

\item{thresh}{vector of numeric for drawing horizontal lines, and also used for
\code{minh} below}

\item{plot}{logical whether to plot the result or simply return the matrix}

\item{verbose}{whether to print results}
}
\value{
returns a list with component:
\itemize{
\item \code{gg} a ggplot object, \code{q} the quantile matrix
\item \code{minh} a quick summary that returns the number of harmonics required to achieve
a certain proportion of the total harmonic power.
}
}
\description{
Estimates the number of harmonics required for the four Fourier methods
implemented in Momocs: elliptical Fourier analysis
(see \link{efourier}), radii variation analysis (see \link{rfourier})
and tangent angle analysis (see \link{tfourier}) and
discrete Fourier transform (see \link{dfourier}).
It returns and can plot cumulated harmonic power whether dropping
the first harmonic or not, and based and the maximum possible number
of harmonics on the \code{Coo} object.
}
\details{
The power of a given harmonic \eqn{n} is calculated as follows for
elliptical Fourier analysis and the n-th harmonic:
\eqn{HarmonicPower_n \frac{A^2_n+B^2_n+C^2_n+D^2_n}{2}}
and as follows for radii variation and tangent angle:
\eqn{HarmonicPower_n= \frac{A^2_n+B^2_n+C^2_n+D^2_n}{2}}
}
\examples{
data(bot)
cal <- calibrate_harmonicpower(bot)
\dontrun{
# for Opn objects
data(olea)
calibrate_harmonicpower(olea, "dfourier")

# let customize the ggplot
library(ggplot2)
cal$gg + theme_minimal() +
coord_cartesian(xlim=c(3.5, 12.5), ylim=c(90, 100)) +
ggtitle("Harmonic power calibration")
}
# if you want to do efourier with 99\% calibrate_harmonicpower in one step
# efourier(bot, nb.h=calibrate_harmonicpower(bot, "efourier", plot=FALSE)$minh["99\%"])

}
\seealso{
Other calibration: \code{\link{calibrate_deviations}},
  \code{\link{calibrate_r2}},
  \code{\link{calibrate_reconstructions}}
}

