% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WriteThunderBirdFilters.R
\name{WriteThunderBirdFilters}
\alias{WriteThunderBirdFilters}
\title{Setup Rule File for ThunderBird & FiltaQuilla}
\usage{
WriteThunderBirdFilters(path = NULL, sent.from = NULL)
}
\arguments{
\item{path}{string, top level folder called the [TriggerPath]}

\item{sent.from}{string, e-mail address you will be sending your triggers
from when you are out of home or office. The mobile e-mail address.}
}
\value{
msgFilterRules.dat on the [TriggerPath].
}
\description{
Function sets up the 6 rules you need to list and run the
Models, Scripts, and Reports
}
\examples{
\donttest{
####################################################
# Setting of MobileTriggers With ThunderBird Rules #
####################################################
  SetupWindowsTrigger(path="c:/triggers",
                      Mail.To = "Your.Email@mobile.com",
                      Mail.From = "R.Triggers@desktop.com",
                      SMTP.Settings=list(
                          host.name = 'some.smtp.sever.com',
                          port = 587,
                          user.name = 'R.Triggers@desktop.com',
                          passwd = 'password', ssl = TRUE)
  )

  WriteThunderBirdFilters(path = "c:/triggers",
                          sent.from = "your.email@Mobile.net")
}
}
