% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motbf.R
\name{univMoTBF}
\alias{univMoTBF}
\title{Fitting MoTBFs}
\usage{
univMoTBF(data, POTENTIAL_TYPE, evalRange = NULL, nparam = NULL,
  maxParam = NULL)
}
\arguments{
\item{data}{A \code{"numeric"} data vector.}

\item{POTENTIAL_TYPE}{A \code{"character"} string specifying the potential
type, must be one of \code{"MOP"} or \code{"MTE"}.}

\item{evalRange}{A \code{"numeric"} vector with the range where defining
the function. By default: it is \code{NULL} and the function is defined
over the data range.}

\item{nparam}{Number of parameters of the function. By default: it is \code{NULL}
and the function fits the best MoTBF taking into account the Bayesian information 
criterion (BIC) to penalize the functions. It evaluates the two next functions,
if the BIC value doesn't improve then the function with the last best BIC is returned.}

\item{maxParam}{A \code{"numeric"} value which indicate the maximum number of coefficients in the function. By default it is \code{NULL}; 
if not, the output is the function which gets the best BIC with at most this number of parameters.}
}
\value{
An \code{"motbf"} function learned from data.
}
\description{
Function for fitting univariate mixture of truncated basis functions.
Least square optimization is used to minimize the quadratic 
error between the empirical cumulative distribution and the estimated one.
}
\examples{
## 1. EXAMPLE
## Data
X <- rnorm(5000)

## Learning
f1 <- univMoTBF(X, POTENTIAL_TYPE = "MTE"); f1
f2 <- univMoTBF(X, POTENTIAL_TYPE = "MOP"); f2

## Plots
hist(X, prob = TRUE, main = "")
plot(f1, xlim = range(X), col = 1, add = TRUE)
plot(f2, xlim = range(X), col = 2, add = TRUE)

## Data test
Xtest <- rnorm(1000)
## Filtered data test
Xtest <- Xtest[Xtest>=min(X) && Xtest<=max(X)]

## Log-likelihood
sum(log(as.function(f1)(Xtest)))
sum(log(as.function(f2)(Xtest)))

## 2. EXAMPLE
## Data
X <- rchisq(5000, df = 5)

## Learning
f1 <- univMoTBF(X, POTENTIAL_TYPE = "MTE", nparam = 11); f1
f2 <- univMoTBF(X, POTENTIAL_TYPE = "MOP", maxParam = 10); f2

## Plots
hist(X, prob = TRUE, main = "")
plot(f1, xlim = range(X), col = 3, add = TRUE)
plot(f2, xlim = range(X), col = 4, add = TRUE)

## Data test
Xtest <- rchisq(1000, df = 5)
## Filtered data test
Xtest <- Xtest[Xtest>=min(X) && Xtest<=max(X)]

## Log-likelihood
sum(log(as.function(f1)(Xtest)))
sum(log(as.function(f2)(Xtest)))

}
