% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/motbf.R
\name{coef.motbf}
\alias{coef.motbf}
\title{Extract MoTBF Coefficients}
\usage{
\method{coef}{motbf}(object, ...)
}
\arguments{
\item{object}{An MoTBF function.}

\item{\dots}{other arguments}
}
\value{
A numeric vector with the parameters of the function.
}
\description{
Extracts the parameters of the learned mixtures of truncated basis
functions.
}
\examples{
## Data
X <- rchisq(2000, df = 5)

## Learning
f1 <- univMoTBF(X, POTENTIAL_TYPE = "MOP"); f1
## Coefficients
coef(f1)

## Learning
f2 <- univMoTBF(X, POTENTIAL_TYPE = "MTE", maxParam = 10); f2
## Coefficients
coef(f2)

## Learning
f3 <- univMoTBF(X, POTENTIAL_TYPE = "MOP", nparam=10); f3
## Coefficients
coef(f3)

## Plots
plot(NULL, xlim = range(X), ylim = c(0,0.2), xlab="X", ylab="density")
plot(f1, xlim = range(X), col = 1, add = TRUE)
plot(f2, xlim = range(X), col = 2, add = TRUE)
plot(f3, xlim = range(X), col = 3, add = TRUE)
hist(X, prob = TRUE, add= TRUE)
}
\seealso{
\link{univMoTBF}, \link{coeffMOP} and \link{coeffMTE}
}

