% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_coreFunctions.R
\name{createWeightedCache}
\alias{createWeightedCache}
\title{createWeightedCache}
\usage{
createWeightedCache(processState, resourceCovariates = NULL)
}
\arguments{
\item{processState}{The processs state that provides the data basis for
creating the cache.}

\item{resourceCovariates}{A vector of resource covariates that will be
used in the model specification.}
}
\value{
A cache object provided as a list.
}
\description{
Creates a necessary internal object used in simulating the chains in the
simulation and estimation of the model.
In case variables of the individuals in the data are included in the state,
they need to be explicitly mentioned in the creation of the cache under
“resourceCovariates”.
}
\examples{
# create cache object
myCache <- createWeightedCache(myState, resourceCovariates = c("sex"))
}
\seealso{
\code{\link[=createProcessState]{createProcessState()}}
}
