% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TestIndSerCopula.R
\name{TestIndSerCopula}
\alias{TestIndSerCopula}
\title{Statistics and P-values for a test of randomness for a univariate time series}
\usage{
TestIndSerCopula(
  x,
  p,
  trunc.level = 2,
  B = 1000,
  par = FALSE,
  ncores = 2,
  graph = FALSE
)
}
\arguments{
\item{x}{Time series}

\item{p}{Number of consecutive observations}

\item{trunc.level}{Only subsets of cardinality <= trunc.level (default=2) are considered for the Moebius statistics.}

\item{B}{Number of multipliers samples (default = 1000)}

\item{par}{Set to TRUE if one prefers paraller computing (slower)}

\item{ncores}{Number of cores for parallel computing (default = 2)}

\item{graph}{Set to TRUE if one wants the dependogram of P-values for the Moebius statistics}
}
\value{
\item{stat}{List of Cramer-von Mises statistics cvm, Sn, and test combinations Tn and Tn2 (only pairs)}

\item{pvalue}{Approximated P-values for the tests using Gaussian multipliers}
}
\description{
This function computes Cramer-von Mises statistics from the multilinear copula and their combination for a tests of randomness for p consectives values X(1), ..., X(p). The p-values are computed using Gaussian multipliers.
}
\references{
B.R Nasri (2022). Tests of serial dependence for arbitrary distributions
}
