% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstDepSerial.R
\name{EstDepSerial}
\alias{EstDepSerial}
\title{Kendall's tau and Spearman's rho statistics for testing randomness in a univariate time series}
\usage{
EstDepSerial(x, lag, graph = FALSE)
}
\arguments{
\item{x}{Time series}

\item{lag}{Number of lags}

\item{graph}{Set to TRUE for a dependogram for Kendall's tau and Spearman;s rho}
}
\value{
\item{stat}{List of Kendall's tau and Spearman's rho statistics from multilinear copula, and test combinations LB}

\item{pvalue}{ P-values for the tests statistics}
}
\description{
This function computes  Kendall's tau and Spearman's rho statistics for tests of randomness in a time series with arbitrary distribution for pairs (X[i],X[i+k]), k=1:lags
}
\examples{
out <-EstDepSerial(SimAR1Poisson(c(5,0.4),100),10)
}
\references{
B.R Nasri (2022). Tests of serial dependence for arbitrary distributions
}
