% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varyprop.R
\name{MixReg_Pvary}
\alias{MixReg_Pvary}
\title{Estimate Mixture of Regression Models with Varying Mixing Proportions}
\usage{
MixReg_Pvary(
  x,
  y,
  numc = NULL,
  z = NULL,
  u = NULL,
  h = NULL,
  kernel = NULL,
  ini = NULL,
  true = NULL
)
}
\arguments{
\item{x}{is an nxp matrix of predictors, intercept will be automatically added to x.}

\item{y}{n vector dimensional of response values}

\item{numc}{number of components, if NULL,numc = 2}

\item{z}{is a variable that proportion varying with. It is a univariate vector and can be part of x}

\item{u}{grid points from z, default is NULL, and 100 equally spaced grid points will
automatically generated using the minimum and maximum of z.}

\item{h}{bandwidth for kernel}

\item{kernel}{kernel for local constant method, 1 = gaussian kernel, 2 = epanechnikov}

\item{ini}{list of initial values:
list(est_p=est_p,est_beta=est_beta,est_var=est_var),
est_p: numc values, est_beta: numc*(p+1), est_var: numc}

\item{true}{list of true values: list(true_p=true_p,true_beta=true_beta,true_var=true_var) true value}
}
\value{
est_p_z : the estimated mixing proportions
est_beta : the estimated regression coefficients
est_var : the estimated global variance
lh : the estimated log-likelihood
initialtrue : whether there is a true value, 1 true, 0 false
}
\description{
Return EM algorithm output for mixture of regression models with varying mixing proportions.
The varying proportions are estimated by local constant method.
}
\examples{
n=100;
numc=2;
u=seq(from=0,to=1,length=100);
true_beta=cbind(c(4,-2),c(0,3));
true_var=c(0.09,0.16);
data = gen_mixreg1(n,numc);
x = data$x;
y = data$y;
true_p = data$true_p;
true=list(true_p=true_p,true_beta=true_beta,true_var=true_var)
est=MixReg_Pvary(x,y,numc,z=x,u,h=0.08,true=true)



}
