% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_drive.R
\docType{class}
\name{ms_drive}
\alias{ms_drive}
\title{Personal OneDrive or SharePoint document library}
\format{
An R6 object of class \code{ms_drive}, inheriting from \code{ms_object}.
}
\description{
Class representing a personal OneDrive or SharePoint document library.
}
\section{Fields}{

\itemize{
\item \code{token}: The token used to authenticate with the Graph host.
\item \code{tenant}: The Azure Active Directory tenant for this drive.
\item \code{type}: always "drive" for a drive object.
\item \code{properties}: The drive properties.
}
}

\section{Methods}{

\itemize{
\item \code{new(...)}: Initialize a new drive object. Do not call this directly; see 'Initialization' below.
\item \code{delete(confirm=TRUE)}: Delete a drive. By default, ask for confirmation first.
\item \code{update(...)}: Update the drive metadata in Microsoft Graph.
\item \code{do_operation(...)}: Carry out an arbitrary operation on the drive.
\item \code{sync_fields()}: Synchronise the R object with the drive metadata in Microsoft Graph.
\item \verb{list_items(...), list_files(...)}: List the files and folders under the specified path. See 'File and folder operations' below.
\item \code{download_file(src, dest, overwrite)}: Download a file.
\item \code{upload_file(src, dest, blocksize)}: Upload a file.
\item \code{create_folder(path)}: Create a folder.
\item \code{open_item(path)}: Open a file or folder.
\item \code{create_share_link(...)}: Create a shareable link for a file or folder.
\item \code{delete_item(path, confirm)}: Delete a file or folder.
\item \code{get_item(path)}: Get an item representing a file or folder.
\item \code{get_item_properties(path)}: Get the properties (metadata) for a file or folder.
\item \code{set_item_properties(path, ...)}: Set the properties for a file or folder.
}
}

\section{Initialization}{

Creating new objects of this class should be done via the \code{get_drive} methods of the \code{\link{ms_graph}}, \code{\link{az_user}} or \code{\link{ms_site}} classes. Calling the \code{new()} method for this class only constructs the R object; it does not call the Microsoft Graph API to retrieve or create the actual drive.
}

\section{File and folder operations}{

This class exposes methods for carrying out common operations on files and folders. They call down to the corresponding methods for the \code{\link{ms_drive_item}} class. In this context, any paths to child items are relative to the root folder of the drive.

\code{open_item} opens the given file or folder in your browser. If the file has an unrecognised type, most browsers will attempt to download it.

\code{list_items(path, info, full_names, pagesize)} lists the items under the specified path.

\code{list_files} is a synonym for \code{list_items}.

\code{download_file} and \code{upload_file} transfer files between the local machine and the drive. For \code{download_file}, the default destination folder is the current (working) directory of your R session. For \code{upload_file}, there is no default destination folder; make sure you specify the destination explicitly.

\code{create_folder} creates a folder with the specified path. Trying to create an already existing folder is an error.

\code{create_share_link(path, type, expiry, password, scope)} returns a shareable link to the item.

\code{delete_item} deletes a file or folder. By default, it will ask for confirmation first.

\code{get_item} retrieves the file or folder with the given path, as an  object of class \code{\link{ms_drive_item}}.

\code{get_item_properties} is a convenience function that returns the properties of a file or folder as a list.

\code{set_item_properties} sets the properties of a file or folder. The new properties should be specified as individual named arguments to the method. Any existing properties that aren't listed as arguments will retain their previous values or be recalculated based on changes to other properties, as appropriate. You can also call the \code{update} method on the corresponding \code{ms_drive_item} object.
}

\examples{
\dontrun{

# personal OneDrive
mydrv <- get_personal_onedrive()

# OneDrive for Business
busdrv <- get_business_onedrive("mycompany")

# shared document library for a SharePoint site
site <- get_sharepoint_site("My site")
drv <- site$get_drive()

## file/folder operationss
drv$list_files()
drv$list_files("path/to/folder", full_names=TRUE)

# download a file -- default destination filename is taken from the source
drv$download_file("path/to/folder/data.csv")

# shareable links
drv$create_share_link("myfile")
drv$create_share_link("myfile", type="edit", expiry="24 hours")
drv$create_share_link("myfile", password="Use-strong-passwords!")

# file metadata (name, date created, etc)
drv$get_item_properties("myfile")

# rename a file
drv$set_item_properties("myfile", name="newname")

}
}
\seealso{
\code{\link{get_personal_onedrive}}, \code{\link{get_business_onedrive}}, \code{\link{ms_site}}, \code{\link{ms_drive_item}}

\href{https://docs.microsoft.com/en-us/graph/overview}{Microsoft Graph overview},
\href{https://docs.microsoft.com/en-us/graph/api/resources/onedrive?view=graph-rest-1.0}{OneDrive API reference}
}
