% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapping.R
\name{map}
\alias{map}
\title{map takes cDNA reads (fastQ format) and maps them onto contigs}
\usage{
map(reads, contigs)
}
\arguments{
\item{reads}{Shortread object or path to short reads file in fastq format}

\item{contigs}{path to contig file in fa format}
}
\description{
uses blat to map the mRNA to the contigs fasta and returns the tabular blast format
blat was chosen for its ability to show multiple hits
https://www.biostars.org/p/17613/
}
\examples{
\dontrun{
# newbler2/K00927
#    454AllContigs.fna
#    input
#        K00927.1.fq
#        K00927.2.fq

lapply(kois, function(ko){
    read1 = sprintf("./newbler2/\%s/input/\%s.2.fq", ko, ko)
    if file.exists(read1)
        read1.fq = read1 \%>\% readFastq
    read2 = sprintf("./newbler2/\%s/input/\%s.2.fq", ko, ko)
    if file.exists(read2)
        read2.fq = read2 \%>\% readFastq
    combined = c(grep.cDNA(read1.fq),grep.cDNA(read2.fq))
    contigs = sprintf("./newbler2/\%s/454AllContigs.fna", ko)
    output = sprintf("./blat/\%s.m8", ko)
    blast8 = map(combined, contigs, output) \%<>\% tbl_df
})
}
}
