% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basics.R
\name{MetaculR_aggregated_forecasts}
\alias{MetaculR_aggregated_forecasts}
\title{Aggregate Community Forecasts for MetaculR}
\usage{
MetaculR_aggregated_forecasts(MetaculR_questions, Metaculus_id, baseline = 0.5)
}
\arguments{
\item{MetaculR_questions}{A MetaculR_questions object}

\item{Metaculus_id}{The ID of the question to plot}

\item{baseline}{Climatological baseline for binary questions}
}
\value{
A dataframe of forecast aggregations.
\item{id}{Question ID.}
\item{community_q2}{Community median.}
\item{community_ave}{Community mean.}
\item{community_q2_unweighted}{Community median, unweighted by recency.}
\item{community_ave_unweighted}{Community mean, unweighted by recency.}
\item{community_mean_logodds}{Community mean of logodds.}
\item{community_mean_logodds_extremized_baseline}{Community mean of logodds, extremized with reference to a baseline. If the baseline is 0.5, this is "classical extremizing."}
}
\description{
Provides different results of aggregating current community forecasts to help you make your next forecast.
}
\details{
Sevilla (2021) found a Metaculus baseline of 0.36 looking at ~900 questions. While Sevilla has at times referred to the geometric mean of odds, this function uses the equivalent mean of logodds. Also note that mu + (d - 1)(mu + b) (Neyman & Roughgarden) is equivalent to b + d(mu + b), this function uses the former.
}
\examples{
\dontrun{
MetaculR_aggregate_forecasts(
  MetaculR_questions = questions_myPredictions,
  Metaculus_id = 10004)
}
}
\references{
Neyman, E., & Roughgarden, T. (2022). Are You Smarter Than a Random Expert? The Robust Aggregation of Substitutable Signals. ArXiv:2111.03153 [Cs]. \url{https://arxiv.org/abs/2111.03153}

Sevilla, J. (2021, December 29). Principled extremizing of aggregated forecasts. \url{https://forum.effectivealtruism.org/posts/biL94PKfeHmgHY6qe/principled-extremizing-of-aggregated-forecasts}
}
