% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkCreateR.R
\name{NetworkCreateR}
\alias{NetworkCreateR}
\title{NetworkCreateR}
\usage{
NetworkCreateR(N, BA_power = 0.5, BA_mValue = 4, plothist = TRUE,
  histbreaks = 50, ...)
}
\arguments{
\item{N}{the number of nodes in the network (metabolites)}

\item{BA_power}{(igrap parameter) The power of the preferential attachment.}

\item{BA_mValue}{(igrap parameter) The number of edges to add in each time step}

\item{plothist}{Whether to plot a histogram of the network's connectivity distribution}

\item{histbreaks}{The number of breaks in the histogram}

\item{...}{Optional additional arguments to be passed along to the network generator function \code{\link[igraph]{sample_pa}}.}
}
\value{
A matrix with the network structure
}
\description{
This function creates a fictional metabolomics network according to the Barabasi-Albert model.
}
\examples{
Network <- NetworkCreateR(N = 50, BA_power = 0.5, BA_mValue = 4)
image(Network)

}
\author{
Charlie Beirnaert, \email{charlie.beirnaert@uantwerpen.be}
}
