% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsdFilter.R
\name{rsdFilter}
\alias{rsdFilter}
\title{RSD Filteirng}
\usage{
rsdFilter(peakTable, eicColumn, rsdColumns, rsdThreshold = 0.3)
}
\arguments{
\item{peakTable}{peak table generated by xcms group object}

\item{eicColumn}{name of the EIC column}

\item{rsdColumns}{names of the sample columns to be used to calcualte RSD}

\item{rsdThreshold}{RSD percent threshold for filtering; default 0.3}
}
\value{
peakTable with filtered EICs
}
\description{
Filters out EICs with RSD % above a user provided threshold.
}
\examples{
\donttest{rsd_filtered_table <- rsdFilter(peakTable = group_table,
                                          eicColumn = eicColumn,
                                          rsdColumns = rsdColumns)}

}
