% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TOI_News_Articles.R
\name{TOI_News_Articles}
\alias{TOI_News_Articles}
\title{Extract Media News}
\usage{
TOI_News_Articles(
  keywords,
  AsDataFrame = TRUE,
  start_date = NULL,
  end_date = NULL
)
}
\arguments{
\item{keywords}{A String, user-defined.}

\item{AsDataFrame}{Boolean Value, to determine whether the outcome should be a
Dataframe or files written to disk. if set to \emph{FALSE} then retuns the
files will be written to disk at stated working directory (default
\emph{TRUE}).}

\item{start_date}{Date (Character) Value, provide the starting date \strong{FROM} where
the data should be extracted. \strong{\emph{NOTE}}: only provide
\code{start_date} when \code{IsDate} is set \emph{TRUE}.}

\item{end_date}{Date (Character) Value, provide the ending date \strong{TO} where the data
should be extracted. \strong{\emph{NOTE}}: only provide \code{end_date} when
\code{IsDate} is set \emph{TRUE}.}
}
\value{
Returns DataFrame or write files to the disk based on \code{keywords}
}
\description{
Creates a DataFrame or Write files to disk by extracting text
 data from source based on user's keywords.
}
\examples{
#### Creates Dataset by filtering 31 days from current date
\donttest{
NewsDataset1 = TOI_News_Articles(keywords = "Politics In US",
start_date = Sys.Date()- 31,
end_date = Sys.Date())

# Creates Dataset by custom filtering through dates
NewsDataset2 = TOI_News_Articles(keywords = "BaseBall",
start_date = "2019-09-20",
end_date = "2019-10-20")

# Write files to disk
TOI_News_Articles(keywords = "AirLines", IsDataFrame = FALSE)
}
}
\seealso{
\code{\link{TOI_News_Dataset}}
}
\author{
Vatsal Aima,  \email{vaima75@hotmail.com}
}
