% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MedSurvey.R
\docType{package}
\name{chisq.BRR}
\alias{chisq.BRR}
\title{Adjust the model fit statistics}
\usage{
chisq.BRR(
  model,
  lavaan.fit,
  data,
  mwgtname,
  repwgtnames,
  fayfactor = 0.5,
  estimator = c("ML"),
  test = c("satorra.bentler")
)
}
\arguments{
\item{model}{The model being fitted. It is written in lavaan model syntax \cite{(Rosseel, 2012)}.}

\item{lavaan.fit}{The model fit results using 'ML' estimator with sample main weights, but without adjusting the fit statistics or standard errors for complex surveys. Note that it is a lavaan object.}

\item{data}{The raw data including the variables of interest and the survey weights. It should be a dataset or dataframe.}

\item{mwgtname}{The variable name indicating the sample main weight in the dataset. See balanced repeated replications method \cite{(Wolter, 2007)} for more information about the main weight.}

\item{repwgtnames}{The variable names indicating the set of replicate weights in the dataset. See balanced repeated replications method \cite{(Wolter, 2007)} for more information about the replicate weight.}

\item{fayfactor}{The fayfactor used in the standard error calculation by fay's method \cite{(Fay & Train, 1995; Judkins, 1990)} for balanced repeated replications. Fayfactor is a value between 0 and 1. The default is 0.5.}

\item{estimator}{The method used to estimate the model. 'ML' is the default option and the only available option for current version. It is not required.}

\item{test}{The method used to generate adjusted standard errors. 'satorra.bentler' is the default option and the only available option for current version. It is not required.}
}
\value{
The model fit results as a lavaan object \cite{(Rosseel, 2012)} with the adjusted model fit statistics.
}
\description{
This function is used to adjust model fit statistics for complex surveys with balanced repeated replications \cite{(Oberski, 2014; Satorra & Muthen, 1995)}. It saves time to only obtain the model fit statistics during the model selection stage.
}
\examples{
\dontshow{
 #Toy example for check:
R <- 20
wgtnames <- paste("repwgt", seq(0,R,by=1), sep="")
mwgtname=wgtnames[1]
repwgtnames=wgtnames[2:(R+1)]
fayfactor=0.5
model1 <- ' # outcome
             numcg ~ u2*1 + c*workban + b*sp_adltban
           # mediator
             sp_adltban ~ u1*1 + a*workban
           # indirect effect (a*b)
             ab := a*b
           # total effect
             total := c + (a*b)
          '
fit <- lavaan::sem(model=model1, data=MedData, estimator='ML', test='standard')
chisq.BRR(model1,fit,MedData,mwgtname, repwgtnames)
}
\donttest{
R <- 160
wgtnames <- paste("repwgt", seq(0,R,by=1), sep="")
mwgtname=wgtnames[1]
repwgtnames=wgtnames[2:(R+1)]
fayfactor=0.5

model3 <- ' # outcome
            numcg ~ u0*1 + c*workban + b1*sp_adltban + b2*sp_kidsban
           # mediator
              sp_adltban ~ u1*1 + a1*workban
              sp_kidsban ~ u2*1 + a2*workban
           # indirect effect (a*b)
              a1b1 := a1*b1
             a2b2 := a2*b2
           # total effect
             total := c + (a1*b1) + (a2*b2)
          '

fit <- lavaan::sem(model=model3, data=MedData, estimator='ML', test='standard')
chisq.BRR(model3,fit,MedData,mwgtname, repwgtnames)
#
# MedSurvey 1.1.0 Adjusted Model Fit Statistics using BRR
#
# chisq   df   pvalue    CFI      RMSEA      SRMR         AIC       BIC
#
# 305.25   1  0.00000   0.40561  0.27852   0.07416   88699.43   88768.45

}

}
\references{
Fay, R. E., & Train, G. F. (1995). Aspects of survey and model-based postcensal estimation of income and poverty characteristics for states and counties. In Proceedings of the Section on Government Statistics, American Statistical Association, Alexandria, VA (pp. 154-159).

Judkins, D. R. (1990). Fay’s method for variance estimation.Journal of Official Statistics,6(3), 223-239.

Oberski, D. (2014). lavaan. survey: An R package for complex survey analysis of structural equation models. Journal of Statistical Software, 57(1), 1-27. DOI:10.18637/jss.v057.i01

Rosseel, Y. (2012). Lavaan: An R package for structural equation modeling and more. Version 0.5–12 (BETA). Journal of statistical software, 48(2), 1-36. DOI:10.18637/jss.v048.i02

Satorra, A., & Muthen, B. (1995). Complex sample data in structural equation modeling. Sociological methodology, 25(1), 267-316.

Wolter, K. (2007). Introduction to variance estimation. New York, NY: Springer.
}
