% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_addLocation.R
\name{table_addLocation}
\alias{table_addLocation}
\title{Add new known location records to a table}
\usage{
table_addLocation(
  locationTbl = NULL,
  longitude = NULL,
  latitude = NULL,
  distanceThreshold = NULL,
  stateDataset = "NaturalEarthAdm1",
  elevationService = NULL,
  addressService = NULL,
  verbose = TRUE
)
}
\arguments{
\item{locationTbl}{Tibble of known locations.}

\item{longitude}{Vector of longitudes in decimal degrees E.}

\item{latitude}{Vector of latitudes in decimal degrees N.}

\item{distanceThreshold}{Distance in meters.}

\item{stateDataset}{Name of spatial dataset to use for determining state
codes, Default: 'NaturalEarthAdm1'}

\item{elevationService}{Name of the elevation service to use for determining
the elevation. Default: NULL. Accepted values: "usgs".}

\item{addressService}{Name of the address service to use for determining
the street address. Default: NULL. Accepted values: "photon".}

\item{verbose}{Logical controlling the generation of progress messages.}
}
\value{
Updated tibble of known locations.
}
\description{
Incoming \code{longitude} and \code{latitude} values are compared 
against the incoming \code{locationTbl} to see if they are already within
\code{distanceThreshold} meters of an existing entry. A new record is created for
each location that is not already found in \code{locationTbl}.
}
\note{
This function is a vectorized version of \code{table_addSingleLocation()}.
}
\examples{
\donttest{
library(MazamaLocationUtils)

# Set up standard directories and spatial data
spatialDataDir <- tempdir() # typically "~/Data/Spatial"
mazama_initialize(spatialDataDir)

locationTbl <- get(data("wa_monitors_500"))

# Coulee City, WA
lon <- -119.290904
lat <- 47.611942

locationTbl <- 
  locationTbl \%>\%
  table_addLocation(lon, lat, distanceThreshold = 500)
  
dplyr::glimpse(locationTbl)
}
}
\seealso{
\link{table_addSingleLocation}

\link{table_removeRecord}

\link{table_updateSingleRecord}
}
