% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeStamp.R
\name{timeStamp}
\alias{timeStamp}
\title{Character representation of a POSIXct}
\usage{
timeStamp(datetime = NULL, timezone = NULL, unit = "sec", style = "ymdhms")
}
\arguments{
\item{datetime}{Vector of character or integer datetimes in Ymd[HMS] format
(or POSIXct).}

\item{timezone}{Olson timezone used to interpret incoming dates (required).}

\item{unit}{Units used to determine precision of generated time stamps.}

\item{style}{Style of representation, Default = "ymdhms".}
}
\value{
A vector of time stamps.
}
\description{
Uses incoming parameters to return a pair of \code{POSIXct} times in the
proper order. Both start and end times will have \code{lubridate::floor_date()}
applied to get the nearest \code{unit} unless \code{ceilingEnd = TRUE} in
which case the end time will will have \code{lubridate::ceiling_date()}
applied.

The required \code{timezone} parameter must be one of those found in
\code{\link[base]{OlsonNames}}.

Formatting output is are affected by both \code{style}:

\itemize{
  \item{\code{"ymdhms"}}
  \item{\code{"ymdThms"}}
  \item{\code{"julian"}}
  \item{\code{"clock"}}
}

and \code{unit} which determines the temporal precision of the generated
representation:

\itemize{
  \item{\code{"year"}}
  \item{\code{"month"}}
  \item{\code{"day"}}
  \item{\code{"hour"}}
  \item{\code{"min"}}
  \item{\code{"sec"}}
  \item{\code{"msec"}}
}

If `style == "julian"` && `unit = "month"``, the timestamp will contain the
Julian day associated with the beginning of the month.
}
\section{POSIXct inputs}{

When \code{startdate} or \code{enddate} are already \code{POSIXct} values,
they are converted to the timezone specified by \code{timezone} without
altering the physical instant in time the input represents. This is different
from the behavior of \code{\link[lubridate]{parse_date_time}} (which powers
this function), which will force \code{POSIXct} inputs into a new timezone,
altering the physical moment of time the input represents.
}

\examples{
library(MazamaCoreUtils)

datetime <- parseDatetime("2019-01-08 12:30:15", timezone = "UTC")

timeStamp(datetime, "UTC", unit = "year")
timeStamp(datetime, "UTC", unit = "month")
timeStamp(datetime, "UTC", unit = "month", style = "julian")
timeStamp(datetime, "UTC", unit = "day")
timeStamp(datetime, "UTC", unit = "day", style = "julian")
timeStamp(datetime, "UTC", unit = "hour")
timeStamp(datetime, "UTC", unit = "min")
timeStamp(datetime, "UTC", unit = "sec")
timeStamp(datetime, "UTC", unit = "sec", style = "ymdThms")
timeStamp(datetime, "UTC", unit = "sec", style = "julian")
timeStamp(datetime, "UTC", unit = "sec", style = "clock")
timeStamp(datetime, "America/Los_Angeles", unit = "sec", style = "clock")
timeStamp(datetime, "America/Los_Angeles", unit = "msec", style = "clock")

}
