% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{hyperposterior_clust}
\alias{hyperposterior_clust}
\title{Compute the hyper-posterior distribution for each cluster in MagmaClust}
\usage{
hyperposterior_clust(
  data,
  mixture,
  hp_k,
  hp_i,
  kern_k,
  kern_i,
  prior_mean_k = NULL,
  grid_inputs = NULL,
  pen_diag = 1e-10
)
}
\arguments{
\item{data}{A tibble or data frame. Required columns: \code{ID}, \code{Input}
, \code{Output}. Additional columns for covariates can be specified.
The \code{ID} column contains the unique names/codes used to identify each
individual/task (or batch of data).
The \code{Input} column should define the variable that is used as
reference for the observations (e.g. time for longitudinal data). The
\code{Output} column specifies the observed values (the response
variable). The data frame can also provide as many covariates as desired,
with no constraints on the column names. These covariates are additional
inputs (explanatory variables) of the models that are also observed at
each reference \code{Input}.}

\item{mixture}{A tibble or data frame, indicating the mixture probabilities
of each cluster for each individual. Required column: \code{ID}.}

\item{hp_k}{A tibble or data frame of hyper-parameters
associated with \code{kern_k}.}

\item{hp_i}{A tibble or data frame of hyper-parameters
associated with \code{kern_i}.}

\item{kern_k}{A kernel function, associated with the mean GPs.
Several popular kernels
(see \href{https://www.cs.toronto.edu/~duvenaud/cookbook/}{The Kernel
Cookbook}) are already implemented and can be selected within the
following list:
\itemize{
\item "SE": (default value) the Squared Exponential Kernel (also called
Radial Basis Function or Gaussian kernel),
\item "LIN": the Linear kernel,
\item "PERIO": the Periodic kernel,
\item "RQ": the Rational Quadratic kernel.
Compound kernels can be created as sums or products of the above kernels.
For combining kernels, simply provide a formula as a character string
where elements are separated by whitespaces (e.g. "SE + PERIO"). As the
elements are treated sequentially from the left to the right, the product
operator '*' shall always be used before the '+' operators (e.g.
'SE * LIN + RQ' is valid whereas 'RQ + SE * LIN' is  not).
}}

\item{kern_i}{A kernel function, associated with the individual GPs. ("SE",
"LIN", PERIO" and "RQ" are also available here)}

\item{prior_mean_k}{The set of hyper-prior mean parameters (m_k) for the K
mean GPs, one value for each cluster.
cluster. This argument can be specified under various formats, such as:
\itemize{
\item NULL (default). All hyper-prior means would be set to 0 everywhere.
\item A numerical vector of the same length as the number of clusters.
Each number is associated with one cluster, and considered
to be the hyper-prior mean parameter of the cluster (i.e. a constant
function at all \code{Input}).
\item A list of functions. Each function is associated with one cluster. These
functions are all evaluated at all \code{Input} values, to provide
specific hyper-prior mean vectors for each cluster.
}}

\item{grid_inputs}{A vector, indicating the grid of additional reference
inputs on which the mean process' hyper-posterior should be evaluated.}

\item{pen_diag}{A number. A jitter term, added on the diagonal to prevent
numerical issues when inverting nearly singular matrices.}
}
\value{
A list containing the parameters of the mean processes'
hyper-posterior distribution, namely:
\itemize{
\item mean: A list of tibbles containing, for each cluster, the
hyper-posterior mean parameters evaluated at each
\code{Input}.
\item cov: A list of matrices containing, for each cluster, the
hyper-posterior covariance parameter of the mean process.
\item mixture: A tibble, indicating the mixture probabilities in
each cluster for each individual.
}
}
\description{
Recompute the E-step of the VEM algorithm in MagmaClust for a new set of
reference \code{Input}. Once training is completed, it can be necessary to
evaluate the hyper-posterior distributions of the mean processes at specific
locations, for which we want to make predictions. This process is directly
implemented in the \code{\link{pred_magmaclust}} function but for the user
might want to use \code{hyperpost_clust} for a tailored control 'by hand' of
the prediction procedure.
}
\examples{
TRUE
}
