% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vem-magmaclust.R
\name{ve_step}
\alias{ve_step}
\title{E-Step of the VEM algorithm}
\usage{
ve_step(db, m_k, kern_k, kern_i, hp_k, hp_i, old_mixture, pen_diag)
}
\arguments{
\item{db}{A tibble or data frame. Columns required: ID, Input, Output.
Additional columns for covariates can be specified.}

\item{m_k}{A named list of vectors, corresponding to the prior mean
parameters of the K mean GPs.}

\item{kern_k}{A kernel function, associated with the K mean GPs.}

\item{kern_i}{A kernel function, associated with the M individual GPs.}

\item{hp_k}{A named vector, tibble or data frame of hyper-parameters
associated with \code{kern_k}.}

\item{hp_i}{A named vector, tibble or data frame of hyper-parameters
associated with \code{kern_i}.}

\item{old_mixture}{A list of mixture values from the previous iteration.}

\item{pen_diag}{A number. A jitter term, added on the diagonal to prevent
numerical issues when inverting nearly singular matrices.}
}
\value{
A named list, containing the elements \code{mean}, a tibble
containing the Input and associated Output of the hyper-posterior mean
parameters, \code{cov}, the hyper-posterior covariance matrices,
and \code{mixture}, the probabilities to belong to each cluster for each
individual.
}
\description{
Expectation step of the Variational EM algorithm used to compute
the parameters of the hyper-posteriors distributions
for the mean processes and mixture variables involved in MagmaClust.
}
\examples{
TRUE
}
