% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernels.R
\name{lin_kernel}
\alias{lin_kernel}
\title{Linear Kernel}
\usage{
lin_kernel(x, y, hp, deriv = NULL, vectorized = FALSE)
}
\arguments{
\item{x}{A vector (or matrix if vectorized = T) of inputs.}

\item{y}{A vector (or matrix if vectorized = T) of inputs.}

\item{hp}{A tibble, data frame or named vector, containing the kernel's
hyperparameters. Required columns: 'lin_slope' and 'lin_offset'.}

\item{deriv}{A character, indicating according to which hyper-parameter the
derivative should be computed. If NULL (default), the function simply
returns the evaluation of the kernel.}

\item{vectorized}{A logical value, indicating whether the function provides
a vectorized version for speeded-up calculations. If TRUE, the \code{x}
and \code{y} arguments should be the vector or matrix containing all
inputs for which the kernel is evaluated on all pairs of elements.
If FALSE, the \code{x} and \code{y} arguments are simply two inputs.}
}
\value{
A scalar, corresponding to the evaluation of the kernel.
}
\description{
Linear Kernel
}
\examples{
TRUE
}
