% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_XGBModel.R
\name{XGBModel}
\alias{XGBModel}
\alias{XGBDARTModel}
\alias{XGBLinearModel}
\alias{XGBTreeModel}
\title{Extreme Gradient Boosting Models}
\usage{
XGBModel(params = list(), nrounds = 1, verbose = 0, print_every_n = 1)

XGBDARTModel(
  objective = NULL,
  aft_loss_distribution = "normal",
  aft_loss_distribution_scale = 1,
  base_score = 0.5,
  eta = 0.3,
  gamma = 0,
  max_depth = 6,
  min_child_weight = 1,
  max_delta_step = .(0.7 * is(y, "PoissonVariate")),
  subsample = 1,
  colsample_bytree = 1,
  colsample_bylevel = 1,
  colsample_bynode = 1,
  lambda = 1,
  alpha = 0,
  tree_method = "auto",
  sketch_eps = 0.03,
  scale_pos_weight = 1,
  refresh_leaf = 1,
  process_type = "default",
  grow_policy = "depthwise",
  max_leaves = 0,
  max_bin = 256,
  num_parallel_tree = 1,
  sample_type = "uniform",
  normalize_type = "tree",
  rate_drop = 0,
  one_drop = 0,
  skip_drop = 0,
  ...
)

XGBLinearModel(
  objective = NULL,
  aft_loss_distribution = "normal",
  aft_loss_distribution_scale = 1,
  base_score = 0.5,
  lambda = 0,
  alpha = 0,
  updater = "shotgun",
  feature_selector = "cyclic",
  top_k = 0,
  ...
)

XGBTreeModel(
  objective = NULL,
  aft_loss_distribution = "normal",
  aft_loss_distribution_scale = 1,
  base_score = 0.5,
  eta = 0.3,
  gamma = 0,
  max_depth = 6,
  min_child_weight = 1,
  max_delta_step = .(0.7 * is(y, "PoissonVariate")),
  subsample = 1,
  colsample_bytree = 1,
  colsample_bylevel = 1,
  colsample_bynode = 1,
  lambda = 1,
  alpha = 0,
  tree_method = "auto",
  sketch_eps = 0.03,
  scale_pos_weight = 1,
  refresh_leaf = 1,
  process_type = "default",
  grow_policy = "depthwise",
  max_leaves = 0,
  max_bin = 256,
  num_parallel_tree = 1,
  ...
)
}
\arguments{
\item{params}{list of model parameters as described in the XGBoost
\href{https://xgboost.readthedocs.io/en/latest/parameter.html}{documentation}.}

\item{nrounds}{maximum number of boosting iterations.}

\item{verbose}{numeric value controlling the amount of output printed
during model fitting, such that 0 = none, 1 = performance information, and
2 = additional information.}

\item{print_every_n}{numeric value designating the fitting iterations at
at which to print output when \code{verbose > 0}.}

\item{objective}{character string specifying the learning task and objective.
Possible values for supported response variable types are as follows.
\describe{
  \item{\code{factor}:}{\code{"multi:softprob"}, \code{"binary:logistic"}
    (2 levels only)}
  \item{\code{numeric}:}{\code{"reg:squarederror"}, \code{"reg:logistic"},
    \code{"reg:gamma"}, \code{"reg:tweedie"}, \code{"rank:pairwise"},
    \code{"rank:ndcg"}, \code{"rank:map"}}
  \item{\code{PoissonVariate}:}{\code{"count:poisson"}}
  \item{\code{Surv}:}{\code{"survival:cox"}, \code{"survival:aft"}}
}
The first values listed are the defaults for the corresponding response
types.}

\item{aft_loss_distribution}{character string specifying the distribution for
the accelerated failure time objective (\code{"survival:aft"}) as
\code{"normal"}, \code{"logistic"}, or \code{"extreme"}.}

\item{aft_loss_distribution_scale}{numeric scaling parameter for the
accelerated failure time distribution.}

\item{base_score}{initial numeric prediction score of all instances, global
bias.}

\item{eta, gamma, max_depth, min_child_weight, max_delta_step, subsample, colsample_bytree, colsample_bylevel, colsample_bynode, lambda, alpha, tree_method, sketch_eps, scale_pos_weight, refresh_leaf, process_type, grow_policy, max_leaves, max_bin, num_parallel_tree, sample_type, normalize_type, rate_drop, one_drop, skip_drop, updater, feature_selector, top_k}{see \code{params} reference.}

\item{...}{arguments passed to \code{XGBModel}.}
}
\value{
\code{MLModel} class object.
}
\description{
Fits models within an efficient implementation of the gradient boosting
framework from Chen & Guestrin.
}
\details{
\describe{
  \item{Response Types:}{\code{factor}, \code{numeric},
    \code{PoissonVariate}, \code{Surv}}
  \item{\link[=TunedModel]{Automatic Tuning} of Grid Parameters}{
    \itemize{
      \item XGBDARTModel: \code{nrounds}, \code{max_depth}, \code{eta},
        \code{gamma}*, \code{min_child_weight}*, \code{subsample},
        \code{colsample_bytree}, \code{rate_drop}, \code{skip_drop}
      \item XGBLinearModel: \code{nrounds}, \code{lambda}, \code{alpha}
      \item XGBTreeModel: \code{nrounds}, \code{max_depth}, \code{eta},
        \code{gamma}*, \code{min_child_weight}*, \code{subsample},
        \code{colsample_bytree}
    }
  }
}
* included only in randomly sampled grid points

Default values for the \code{NULL} arguments and further model details can be
found in the source link below.

In calls to \code{\link{varimp}} for \code{XGBTreeModel}, argument
\code{metric} may be specified as \code{"Gain"} (default) for the fractional
contribution of each predictor to the total gain of its splits, as
\code{"Cover"} for the number of observations related to each predictor, or
as \code{"Frequency"} for the percentage of times each predictor is used in
the trees.  Variable importance is automatically scaled to range from 0 to
100.  To obtain unscaled importance values, set \code{scale = FALSE}.  See
example below.
}
\examples{
model_fit <- fit(Species ~ ., data = iris, model = XGBTreeModel)
varimp(model_fit, metric = "Frequency", scale = FALSE)

}
\seealso{
\code{\link[xgboost:xgb.train]{xgboost}}, \code{\link{fit}},
\code{\link{resample}}
}
