% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{ParameterGrid}
\alias{ParameterGrid}
\title{Tuning Parameters Grid}
\usage{
ParameterGrid(..., length = 3, random = FALSE)
}
\arguments{
\item{...}{\code{\link[dials]{parameters}} object, named \code{param} objects
as defined in the \pkg{dials} package, or a list of these.}

\item{length}{single number or vector of numbers of parameter values to use
in constructing a regular grid if \code{random = FALSE}; ignored otherwise.}

\item{random}{number of unique grid points to sample at random or
\code{FALSE} for all points from a regular grid defined by \code{length}.}
}
\value{
\code{ParameterGrid} class object that inherits from
\code{parameters} and \code{Grid}.
}
\description{
Defines a tuning grid from a set of parameters.
}
\examples{
## GBMModel tuning parameters
library(dials)

grid <- ParameterGrid(
  n.trees = trees(),
  interaction.depth = tree_depth(),
  random = 5
)
TunedModel(GBMModel, grid = grid)

}
\seealso{
\code{\link{TunedModel}}
}
