% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample.R
\name{resample}
\alias{resample}
\alias{resample.formula}
\alias{resample.matrix}
\alias{resample.ModelFrame}
\alias{resample.recipe}
\alias{resample.MLModel}
\alias{resample.MLModelFunction}
\alias{Resamples}
\title{Resample Estimation of Model Performance}
\usage{
resample(x, ...)

\method{resample}{formula}(x, data, model,
  control = MachineShop::settings("control"), ...)

\method{resample}{matrix}(x, y, model,
  control = MachineShop::settings("control"), ...)

\method{resample}{ModelFrame}(x, model,
  control = MachineShop::settings("control"), ...)

\method{resample}{recipe}(x, model,
  control = MachineShop::settings("control"), ...)

\method{resample}{MLModel}(x, ...)

\method{resample}{MLModelFunction}(x, ...)

Resamples(...)
}
\arguments{
\item{x}{defines a relationship between model predictor and response
variables.  May be a \code{\link{formula}}, design \code{\link{matrix}} of
predictors, \code{\link{ModelFrame}}, untrained
\code{\link[recipes]{recipe}}, or \code{\link{TunedRecipe}} object.
Alternatively, a \link[=models]{model} function or call may be given first
followed by objects defining the predictor and response relationship and
the \code{control} value.}

\item{...}{named or unnamed \code{resample} output to combine together with
the \code{Resamples} constructor.}

\item{data}{\link[=data.frame]{data frame} containing observed predictors and
outcomes.}

\item{model}{\link[=models]{model} function, function name, or call.}

\item{control}{\link[=controls]{control} function, function name, or call
defining the resampling method to be employed.}

\item{y}{response variable.}
}
\value{
\code{Resamples} class object.
}
\description{
Estimation of the predictive performance of a model estimated and evaluated
on training and test samples generated from an observed data set.
}
\details{
Stratified resampling is performed for the \code{formula} method according to
values of the response variable; i.e. categorical levels for \code{factor},
continuous for \code{numeric}, and event status \code{Surv}.

User-specified stratification variables may be specified for
\code{ModelFrames} upon creation with the \code{\link[=ModelFrame]{strata}}
argument in its constructor.  Resampling of this class is unstratified by
default.

Variables in a \code{recipe} may be used for stratification by defining a
"case_strata" \code{\link[recipes:roles]{role}} for them.  Resampling will
be unstratified if no variables have that role.

Output being combined from more than one model with the \code{Resamples}
constructor must have been generated with the same resampling \code{control}
object.
}
\examples{
## Factor response example

fo <- Species ~ .
control <- CVControl()

gbm_res1 <- resample(fo, iris, GBMModel(n.trees = 25), control)
gbm_res2 <- resample(fo, iris, GBMModel(n.trees = 50), control)
gbm_res3 <- resample(fo, iris, GBMModel(n.trees = 100), control)

summary(gbm_res1)
plot(gbm_res1)

res <- Resamples(GBM1 = gbm_res1, GBM2 = gbm_res2, GBM3 = gbm_res3)
summary(res)
plot(res)

}
\seealso{
\code{\link{performance}}, \code{\link{metrics}},
\code{\link{plot}}, \code{\link{summary}}
}
