% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lift.R
\name{lift}
\alias{lift}
\alias{Lift}
\title{Model Lift}
\usage{
lift(x, y = NULL, na.rm = TRUE, ...)

Lift(...)
}
\arguments{
\item{x}{\link[=response]{observed responses} or \link{resample} result
containing observed and predicted responses.}

\item{y}{\link[=predict]{predicted responses} if not contained in \code{x}.}

\item{na.rm}{logical indicating whether to remove observed or predicted
responses that are \code{NA} when calculating metrics.}

\item{...}{named or unnamed \code{lift} output to combine together with the
\code{Lift} constructor.}
}
\value{
\code{Lift} class object that inherits from \code{Curves}.
}
\description{
Calculate lift estimates from observed and predicted responses.
}
\examples{
library(MASS)

res <- resample(type ~ ., data = Pima.tr, model = GBMModel)
lf <- lift(res)
plot(lf)

}
\seealso{
\code{\link{plot}}, \code{\link{summary}}
}
