% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_SuperModel.R
\name{SuperModel}
\alias{SuperModel}
\title{Super Learner Model}
\usage{
SuperModel(..., model = GBMModel, control = CVControl,
  all_vars = FALSE)
}
\arguments{
\item{...}{\code{MLModel} objects to serve as base learners.}

\item{model}{\code{MLModel} object, constructor function, or character string
naming a constructor function to serve as the super model.}

\item{control}{\code{\link{MLControl}} object, control function, or character
string naming a control function defining the resampling method to be
employed for the estimation of base learner weights.}

\item{all_vars}{logical indicating whether to include the original
predictor variables in the super model.}
}
\value{
\code{SuperModel} class object that inherits from \code{MLModel}.
}
\description{
Fit a super learner model to predictions from multiple base learners.
}
\details{
\describe{
\item{Response Types:}{\code{factor}, \code{numeric}, \code{ordered},
\code{Surv}
}
}
}
\examples{
model <- SuperModel(GBMModel, SVMRadialModel, GLMNetModel(lambda = 0.01))
modelfit <- fit(sale_amount ~ ., data = ICHomes, model = model)
predict(modelfit, newdata = ICHomes)

}
\references{
van der Lann, M.J., Hubbard A.E. (2007) \emph{Super Learner.} Statistical
Applications in Genetics and Molecular Biology, 6(1).
}
\seealso{
\code{\link{fit}}, \code{\link{resample}}, \code{\link{tune}}
}
